<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for day StructType
 * @subpackage Structs
 */
class Day extends AbstractStructBase
{
    /**
     * The dayId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $dayId;
    /**
     * The dayText
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $dayText;
    /**
     * Constructor method for day
     * @uses Day::setDayId()
     * @uses Day::setDayText()
     * @param int $dayId
     * @param string $dayText
     */
    public function __construct($dayId = null, $dayText = null)
    {
        $this
            ->setDayId($dayId)
            ->setDayText($dayText);
    }
    /**
     * Get dayId value
     * @return int
     */
    public function getDayId()
    {
        return $this->dayId;
    }
    /**
     * Set dayId value
     * @param int $dayId
     * @return \StructType\Day
     */
    public function setDayId($dayId = null)
    {
        // validation for constraint: int
        if (!is_null($dayId) && !(is_int($dayId) || ctype_digit($dayId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($dayId, true), gettype($dayId)), __LINE__);
        }
        $this->dayId = $dayId;
        return $this;
    }
    /**
     * Get dayText value
     * @return string|null
     */
    public function getDayText()
    {
        return $this->dayText;
    }
    /**
     * Set dayText value
     * @param string $dayText
     * @return \StructType\Day
     */
    public function setDayText($dayText = null)
    {
        // validation for constraint: string
        if (!is_null($dayText) && !is_string($dayText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dayText, true), gettype($dayText)), __LINE__);
        }
        $this->dayText = $dayText;
        return $this;
    }
}
