<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for engineSpecialOffer StructType
 * @subpackage Structs
 */
class EngineSpecialOffer extends AbstractStructBase
{
    /**
     * The SurOffreId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SurOffreId;
    /**
     * The OS_engineReduction
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $OS_engineReduction;
    /**
     * The EngineOfferLabel
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\EngineOfferLabel
     */
    public $EngineOfferLabel;
    /**
     * Constructor method for engineSpecialOffer
     * @uses EngineSpecialOffer::setSurOffreId()
     * @uses EngineSpecialOffer::setOS_engineReduction()
     * @uses EngineSpecialOffer::setEngineOfferLabel()
     * @param int $surOffreId
     * @param float $oS_engineReduction
     * @param \StructType\EngineOfferLabel $engineOfferLabel
     */
    public function __construct($surOffreId = null, $oS_engineReduction = null, \StructType\EngineOfferLabel $engineOfferLabel = null)
    {
        $this
            ->setSurOffreId($surOffreId)
            ->setOS_engineReduction($oS_engineReduction)
            ->setEngineOfferLabel($engineOfferLabel);
    }
    /**
     * Get SurOffreId value
     * @return int
     */
    public function getSurOffreId()
    {
        return $this->SurOffreId;
    }
    /**
     * Set SurOffreId value
     * @param int $surOffreId
     * @return \StructType\EngineSpecialOffer
     */
    public function setSurOffreId($surOffreId = null)
    {
        // validation for constraint: int
        if (!is_null($surOffreId) && !(is_int($surOffreId) || ctype_digit($surOffreId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($surOffreId, true), gettype($surOffreId)), __LINE__);
        }
        $this->SurOffreId = $surOffreId;
        return $this;
    }
    /**
     * Get OS_engineReduction value
     * @return float
     */
    public function getOS_engineReduction()
    {
        return $this->OS_engineReduction;
    }
    /**
     * Set OS_engineReduction value
     * @param float $oS_engineReduction
     * @return \StructType\EngineSpecialOffer
     */
    public function setOS_engineReduction($oS_engineReduction = null)
    {
        // validation for constraint: float
        if (!is_null($oS_engineReduction) && !(is_float($oS_engineReduction) || is_numeric($oS_engineReduction))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($oS_engineReduction, true), gettype($oS_engineReduction)), __LINE__);
        }
        $this->OS_engineReduction = $oS_engineReduction;
        return $this;
    }
    /**
     * Get EngineOfferLabel value
     * @return \StructType\EngineOfferLabel|null
     */
    public function getEngineOfferLabel()
    {
        return $this->EngineOfferLabel;
    }
    /**
     * Set EngineOfferLabel value
     * @param \StructType\EngineOfferLabel $engineOfferLabel
     * @return \StructType\EngineSpecialOffer
     */
    public function setEngineOfferLabel(\StructType\EngineOfferLabel $engineOfferLabel = null)
    {
        $this->EngineOfferLabel = $engineOfferLabel;
        return $this;
    }
}
