<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfTypeOS ArrayType
 * @subpackage Arrays
 */
class ArrayOfTypeOS extends AbstractStructArrayBase
{
    /**
     * The TypeOS
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $TypeOS;
    /**
     * Constructor method for ArrayOfTypeOS
     * @uses ArrayOfTypeOS::setTypeOS()
     * @param string[] $typeOS
     */
    public function __construct(array $typeOS = array())
    {
        $this
            ->setTypeOS($typeOS);
    }
    /**
     * Get TypeOS value
     * @return string[]|null
     */
    public function getTypeOS()
    {
        return $this->TypeOS;
    }
    /**
     * This method is responsible for validating the values passed to the setTypeOS method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTypeOS method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTypeOSForArrayConstraintsFromSetTypeOS(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfTypeOSTypeOSItem) {
            // validation for constraint: enumeration
            if (!\EnumType\TypeOS::valueIsValid($arrayOfTypeOSTypeOSItem)) {
                $invalidValues[] = is_object($arrayOfTypeOSTypeOSItem) ? get_class($arrayOfTypeOSTypeOSItem) : sprintf('%s(%s)', gettype($arrayOfTypeOSTypeOSItem), var_export($arrayOfTypeOSTypeOSItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TypeOS', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\TypeOS::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TypeOS value
     * @uses \EnumType\TypeOS::valueIsValid()
     * @uses \EnumType\TypeOS::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $typeOS
     * @return \ArrayType\ArrayOfTypeOS
     */
    public function setTypeOS(array $typeOS = array())
    {
        // validation for constraint: array
        if ('' !== ($typeOSArrayErrorMessage = self::validateTypeOSForArrayConstraintsFromSetTypeOS($typeOS))) {
            throw new \InvalidArgumentException($typeOSArrayErrorMessage, __LINE__);
        }
        $this->TypeOS = $typeOS;
        return $this;
    }
    /**
     * Add item to TypeOS value
     * @uses \EnumType\TypeOS::valueIsValid()
     * @uses \EnumType\TypeOS::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \ArrayType\ArrayOfTypeOS
     */
    public function addToTypeOS($item)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TypeOS::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TypeOS', is_array($item) ? implode(', ', $item) : var_export($item, true), implode(', ', \EnumType\TypeOS::getValidValues())), __LINE__);
        }
        $this->TypeOS[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return string|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return string|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return string|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return string|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return string|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Add element to array
     * @see AbstractStructArrayBase::add()
     * @throws \InvalidArgumentException
     * @uses \EnumType\TypeOS::valueIsValid()
     * @param string $item
     * @return \ArrayType\ArrayOfTypeOS
     */
    public function add($item)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TypeOS::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TypeOS', is_array($item) ? implode(', ', $item) : var_export($item, true), implode(', ', \EnumType\TypeOS::getValidValues())), __LINE__);
        }
        return parent::add($item);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string TypeOS
     */
    public function getAttributeName()
    {
        return 'TypeOS';
    }
}
