<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfProductsInventoryCategory ArrayType
 * @subpackage Arrays
 */
class ArrayOfProductsInventoryCategory extends AbstractStructArrayBase
{
    /**
     * The ProductsInventoryCategory
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $ProductsInventoryCategory;
    /**
     * Constructor method for ArrayOfProductsInventoryCategory
     * @uses ArrayOfProductsInventoryCategory::setProductsInventoryCategory()
     * @param string[] $productsInventoryCategory
     */
    public function __construct(array $productsInventoryCategory = array())
    {
        $this
            ->setProductsInventoryCategory($productsInventoryCategory);
    }
    /**
     * Get ProductsInventoryCategory value
     * @return string[]|null
     */
    public function getProductsInventoryCategory()
    {
        return $this->ProductsInventoryCategory;
    }
    /**
     * This method is responsible for validating the values passed to the setProductsInventoryCategory method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProductsInventoryCategory method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProductsInventoryCategoryForArrayConstraintsFromSetProductsInventoryCategory(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfProductsInventoryCategoryProductsInventoryCategoryItem) {
            // validation for constraint: enumeration
            if (!\EnumType\ProductsInventoryCategory::valueIsValid($arrayOfProductsInventoryCategoryProductsInventoryCategoryItem)) {
                $invalidValues[] = is_object($arrayOfProductsInventoryCategoryProductsInventoryCategoryItem) ? get_class($arrayOfProductsInventoryCategoryProductsInventoryCategoryItem) : sprintf('%s(%s)', gettype($arrayOfProductsInventoryCategoryProductsInventoryCategoryItem), var_export($arrayOfProductsInventoryCategoryProductsInventoryCategoryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ProductsInventoryCategory', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\ProductsInventoryCategory::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ProductsInventoryCategory value
     * @uses \EnumType\ProductsInventoryCategory::valueIsValid()
     * @uses \EnumType\ProductsInventoryCategory::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $productsInventoryCategory
     * @return \ArrayType\ArrayOfProductsInventoryCategory
     */
    public function setProductsInventoryCategory(array $productsInventoryCategory = array())
    {
        // validation for constraint: array
        if ('' !== ($productsInventoryCategoryArrayErrorMessage = self::validateProductsInventoryCategoryForArrayConstraintsFromSetProductsInventoryCategory($productsInventoryCategory))) {
            throw new \InvalidArgumentException($productsInventoryCategoryArrayErrorMessage, __LINE__);
        }
        $this->ProductsInventoryCategory = $productsInventoryCategory;
        return $this;
    }
    /**
     * Add item to ProductsInventoryCategory value
     * @uses \EnumType\ProductsInventoryCategory::valueIsValid()
     * @uses \EnumType\ProductsInventoryCategory::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \ArrayType\ArrayOfProductsInventoryCategory
     */
    public function addToProductsInventoryCategory($item)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ProductsInventoryCategory::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ProductsInventoryCategory', is_array($item) ? implode(', ', $item) : var_export($item, true), implode(', ', \EnumType\ProductsInventoryCategory::getValidValues())), __LINE__);
        }
        $this->ProductsInventoryCategory[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return string|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return string|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return string|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return string|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return string|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Add element to array
     * @see AbstractStructArrayBase::add()
     * @throws \InvalidArgumentException
     * @uses \EnumType\ProductsInventoryCategory::valueIsValid()
     * @param string $item
     * @return \ArrayType\ArrayOfProductsInventoryCategory
     */
    public function add($item)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ProductsInventoryCategory::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ProductsInventoryCategory', is_array($item) ? implode(', ', $item) : var_export($item, true), implode(', ', \EnumType\ProductsInventoryCategory::getValidValues())), __LINE__);
        }
        return parent::add($item);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ProductsInventoryCategory
     */
    public function getAttributeName()
    {
        return 'ProductsInventoryCategory';
    }
}
