<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StayIdentifier StructType
 * @subpackage Structs
 */
class StayIdentifier extends AbstractStructBase
{
    /**
     * The EstablishmentId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $EstablishmentId;
    /**
     * The ProductId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ProductId;
    /**
     * The DateBegin
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DateBegin;
    /**
     * The DateEnd
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DateEnd;
    /**
     * The Tac
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Tac;
    /**
     * The Spec
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Spec;
    /**
     * The GuestList
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfGuest
     */
    public $GuestList;
    /**
     * The DiscountCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DiscountCode;
    /**
     * The PersonsDetails
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfDetailedPersonFilter
     */
    public $PersonsDetails;
    /**
     * Constructor method for StayIdentifier
     * @uses StayIdentifier::setEstablishmentId()
     * @uses StayIdentifier::setProductId()
     * @uses StayIdentifier::setDateBegin()
     * @uses StayIdentifier::setDateEnd()
     * @uses StayIdentifier::setTac()
     * @uses StayIdentifier::setSpec()
     * @uses StayIdentifier::setGuestList()
     * @uses StayIdentifier::setDiscountCode()
     * @uses StayIdentifier::setPersonsDetails()
     * @param int $establishmentId
     * @param int $productId
     * @param string $dateBegin
     * @param string $dateEnd
     * @param string $tac
     * @param string $spec
     * @param \ArrayType\ArrayOfGuest $guestList
     * @param string $discountCode
     * @param \ArrayType\ArrayOfDetailedPersonFilter $personsDetails
     */
    public function __construct($establishmentId = null, $productId = null, $dateBegin = null, $dateEnd = null, $tac = null, $spec = null, \ArrayType\ArrayOfGuest $guestList = null, $discountCode = null, \ArrayType\ArrayOfDetailedPersonFilter $personsDetails = null)
    {
        $this
            ->setEstablishmentId($establishmentId)
            ->setProductId($productId)
            ->setDateBegin($dateBegin)
            ->setDateEnd($dateEnd)
            ->setTac($tac)
            ->setSpec($spec)
            ->setGuestList($guestList)
            ->setDiscountCode($discountCode)
            ->setPersonsDetails($personsDetails);
    }
    /**
     * Get EstablishmentId value
     * @return int
     */
    public function getEstablishmentId()
    {
        return $this->EstablishmentId;
    }
    /**
     * Set EstablishmentId value
     * @param int $establishmentId
     * @return \StructType\StayIdentifier
     */
    public function setEstablishmentId($establishmentId = null)
    {
        // validation for constraint: int
        if (!is_null($establishmentId) && !(is_int($establishmentId) || ctype_digit($establishmentId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($establishmentId, true), gettype($establishmentId)), __LINE__);
        }
        $this->EstablishmentId = $establishmentId;
        return $this;
    }
    /**
     * Get ProductId value
     * @return int
     */
    public function getProductId()
    {
        return $this->ProductId;
    }
    /**
     * Set ProductId value
     * @param int $productId
     * @return \StructType\StayIdentifier
     */
    public function setProductId($productId = null)
    {
        // validation for constraint: int
        if (!is_null($productId) && !(is_int($productId) || ctype_digit($productId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($productId, true), gettype($productId)), __LINE__);
        }
        $this->ProductId = $productId;
        return $this;
    }
    /**
     * Get DateBegin value
     * @return string
     */
    public function getDateBegin()
    {
        return $this->DateBegin;
    }
    /**
     * Set DateBegin value
     * @param string $dateBegin
     * @return \StructType\StayIdentifier
     */
    public function setDateBegin($dateBegin = null)
    {
        // validation for constraint: string
        if (!is_null($dateBegin) && !is_string($dateBegin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateBegin, true), gettype($dateBegin)), __LINE__);
        }
        $this->DateBegin = $dateBegin;
        return $this;
    }
    /**
     * Get DateEnd value
     * @return string
     */
    public function getDateEnd()
    {
        return $this->DateEnd;
    }
    /**
     * Set DateEnd value
     * @param string $dateEnd
     * @return \StructType\StayIdentifier
     */
    public function setDateEnd($dateEnd = null)
    {
        // validation for constraint: string
        if (!is_null($dateEnd) && !is_string($dateEnd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateEnd, true), gettype($dateEnd)), __LINE__);
        }
        $this->DateEnd = $dateEnd;
        return $this;
    }
    /**
     * Get Tac value
     * @return string|null
     */
    public function getTac()
    {
        return $this->Tac;
    }
    /**
     * Set Tac value
     * @param string $tac
     * @return \StructType\StayIdentifier
     */
    public function setTac($tac = null)
    {
        // validation for constraint: string
        if (!is_null($tac) && !is_string($tac)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tac, true), gettype($tac)), __LINE__);
        }
        $this->Tac = $tac;
        return $this;
    }
    /**
     * Get Spec value
     * @return string|null
     */
    public function getSpec()
    {
        return $this->Spec;
    }
    /**
     * Set Spec value
     * @param string $spec
     * @return \StructType\StayIdentifier
     */
    public function setSpec($spec = null)
    {
        // validation for constraint: string
        if (!is_null($spec) && !is_string($spec)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($spec, true), gettype($spec)), __LINE__);
        }
        $this->Spec = $spec;
        return $this;
    }
    /**
     * Get GuestList value
     * @return \ArrayType\ArrayOfGuest|null
     */
    public function getGuestList()
    {
        return $this->GuestList;
    }
    /**
     * Set GuestList value
     * @param \ArrayType\ArrayOfGuest $guestList
     * @return \StructType\StayIdentifier
     */
    public function setGuestList(\ArrayType\ArrayOfGuest $guestList = null)
    {
        $this->GuestList = $guestList;
        return $this;
    }
    /**
     * Get DiscountCode value
     * @return string|null
     */
    public function getDiscountCode()
    {
        return $this->DiscountCode;
    }
    /**
     * Set DiscountCode value
     * @param string $discountCode
     * @return \StructType\StayIdentifier
     */
    public function setDiscountCode($discountCode = null)
    {
        // validation for constraint: string
        if (!is_null($discountCode) && !is_string($discountCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($discountCode, true), gettype($discountCode)), __LINE__);
        }
        $this->DiscountCode = $discountCode;
        return $this;
    }
    /**
     * Get PersonsDetails value
     * @return \ArrayType\ArrayOfDetailedPersonFilter|null
     */
    public function getPersonsDetails()
    {
        return $this->PersonsDetails;
    }
    /**
     * Set PersonsDetails value
     * @param \ArrayType\ArrayOfDetailedPersonFilter $personsDetails
     * @return \StructType\StayIdentifier
     */
    public function setPersonsDetails(\ArrayType\ArrayOfDetailedPersonFilter $personsDetails = null)
    {
        $this->PersonsDetails = $personsDetails;
        return $this;
    }
}
