<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TunnelCartPrices StructType
 * @subpackage Structs
 */
class TunnelCartPrices extends AbstractStructBase
{
    /**
     * The NormalBasePrice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $NormalBasePrice;
    /**
     * The DiscountBasePrice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $DiscountBasePrice;
    /**
     * The BookingFees
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $BookingFees;
    /**
     * The TotalPriceWithOptionsAndBookingFees
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TotalPriceWithOptionsAndBookingFees;
    /**
     * The TotalOptionPrice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TotalOptionPrice;
    /**
     * The TaxesPrice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TaxesPrice;
    /**
     * The NormalBasePriceWithOptionsAndBookingFees
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $NormalBasePriceWithOptionsAndBookingFees;
    /**
     * The DiscountBasePriceWithOptionsAndBookingFees
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $DiscountBasePriceWithOptionsAndBookingFees;
    /**
     * The PriceWithBookingFees
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $PriceWithBookingFees;
    /**
     * The Currency
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Currency;
    /**
     * Constructor method for TunnelCartPrices
     * @uses TunnelCartPrices::setNormalBasePrice()
     * @uses TunnelCartPrices::setDiscountBasePrice()
     * @uses TunnelCartPrices::setBookingFees()
     * @uses TunnelCartPrices::setTotalPriceWithOptionsAndBookingFees()
     * @uses TunnelCartPrices::setTotalOptionPrice()
     * @uses TunnelCartPrices::setTaxesPrice()
     * @uses TunnelCartPrices::setNormalBasePriceWithOptionsAndBookingFees()
     * @uses TunnelCartPrices::setDiscountBasePriceWithOptionsAndBookingFees()
     * @uses TunnelCartPrices::setPriceWithBookingFees()
     * @uses TunnelCartPrices::setCurrency()
     * @param float $normalBasePrice
     * @param float $discountBasePrice
     * @param float $bookingFees
     * @param float $totalPriceWithOptionsAndBookingFees
     * @param float $totalOptionPrice
     * @param float $taxesPrice
     * @param float $normalBasePriceWithOptionsAndBookingFees
     * @param float $discountBasePriceWithOptionsAndBookingFees
     * @param float $priceWithBookingFees
     * @param string $currency
     */
    public function __construct($normalBasePrice = null, $discountBasePrice = null, $bookingFees = null, $totalPriceWithOptionsAndBookingFees = null, $totalOptionPrice = null, $taxesPrice = null, $normalBasePriceWithOptionsAndBookingFees = null, $discountBasePriceWithOptionsAndBookingFees = null, $priceWithBookingFees = null, $currency = null)
    {
        $this
            ->setNormalBasePrice($normalBasePrice)
            ->setDiscountBasePrice($discountBasePrice)
            ->setBookingFees($bookingFees)
            ->setTotalPriceWithOptionsAndBookingFees($totalPriceWithOptionsAndBookingFees)
            ->setTotalOptionPrice($totalOptionPrice)
            ->setTaxesPrice($taxesPrice)
            ->setNormalBasePriceWithOptionsAndBookingFees($normalBasePriceWithOptionsAndBookingFees)
            ->setDiscountBasePriceWithOptionsAndBookingFees($discountBasePriceWithOptionsAndBookingFees)
            ->setPriceWithBookingFees($priceWithBookingFees)
            ->setCurrency($currency);
    }
    /**
     * Get NormalBasePrice value
     * @return float
     */
    public function getNormalBasePrice()
    {
        return $this->NormalBasePrice;
    }
    /**
     * Set NormalBasePrice value
     * @param float $normalBasePrice
     * @return \StructType\TunnelCartPrices
     */
    public function setNormalBasePrice($normalBasePrice = null)
    {
        // validation for constraint: float
        if (!is_null($normalBasePrice) && !(is_float($normalBasePrice) || is_numeric($normalBasePrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($normalBasePrice, true), gettype($normalBasePrice)), __LINE__);
        }
        $this->NormalBasePrice = $normalBasePrice;
        return $this;
    }
    /**
     * Get DiscountBasePrice value
     * @return float
     */
    public function getDiscountBasePrice()
    {
        return $this->DiscountBasePrice;
    }
    /**
     * Set DiscountBasePrice value
     * @param float $discountBasePrice
     * @return \StructType\TunnelCartPrices
     */
    public function setDiscountBasePrice($discountBasePrice = null)
    {
        // validation for constraint: float
        if (!is_null($discountBasePrice) && !(is_float($discountBasePrice) || is_numeric($discountBasePrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($discountBasePrice, true), gettype($discountBasePrice)), __LINE__);
        }
        $this->DiscountBasePrice = $discountBasePrice;
        return $this;
    }
    /**
     * Get BookingFees value
     * @return float
     */
    public function getBookingFees()
    {
        return $this->BookingFees;
    }
    /**
     * Set BookingFees value
     * @param float $bookingFees
     * @return \StructType\TunnelCartPrices
     */
    public function setBookingFees($bookingFees = null)
    {
        // validation for constraint: float
        if (!is_null($bookingFees) && !(is_float($bookingFees) || is_numeric($bookingFees))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($bookingFees, true), gettype($bookingFees)), __LINE__);
        }
        $this->BookingFees = $bookingFees;
        return $this;
    }
    /**
     * Get TotalPriceWithOptionsAndBookingFees value
     * @return float
     */
    public function getTotalPriceWithOptionsAndBookingFees()
    {
        return $this->TotalPriceWithOptionsAndBookingFees;
    }
    /**
     * Set TotalPriceWithOptionsAndBookingFees value
     * @param float $totalPriceWithOptionsAndBookingFees
     * @return \StructType\TunnelCartPrices
     */
    public function setTotalPriceWithOptionsAndBookingFees($totalPriceWithOptionsAndBookingFees = null)
    {
        // validation for constraint: float
        if (!is_null($totalPriceWithOptionsAndBookingFees) && !(is_float($totalPriceWithOptionsAndBookingFees) || is_numeric($totalPriceWithOptionsAndBookingFees))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalPriceWithOptionsAndBookingFees, true), gettype($totalPriceWithOptionsAndBookingFees)), __LINE__);
        }
        $this->TotalPriceWithOptionsAndBookingFees = $totalPriceWithOptionsAndBookingFees;
        return $this;
    }
    /**
     * Get TotalOptionPrice value
     * @return float
     */
    public function getTotalOptionPrice()
    {
        return $this->TotalOptionPrice;
    }
    /**
     * Set TotalOptionPrice value
     * @param float $totalOptionPrice
     * @return \StructType\TunnelCartPrices
     */
    public function setTotalOptionPrice($totalOptionPrice = null)
    {
        // validation for constraint: float
        if (!is_null($totalOptionPrice) && !(is_float($totalOptionPrice) || is_numeric($totalOptionPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalOptionPrice, true), gettype($totalOptionPrice)), __LINE__);
        }
        $this->TotalOptionPrice = $totalOptionPrice;
        return $this;
    }
    /**
     * Get TaxesPrice value
     * @return float
     */
    public function getTaxesPrice()
    {
        return $this->TaxesPrice;
    }
    /**
     * Set TaxesPrice value
     * @param float $taxesPrice
     * @return \StructType\TunnelCartPrices
     */
    public function setTaxesPrice($taxesPrice = null)
    {
        // validation for constraint: float
        if (!is_null($taxesPrice) && !(is_float($taxesPrice) || is_numeric($taxesPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxesPrice, true), gettype($taxesPrice)), __LINE__);
        }
        $this->TaxesPrice = $taxesPrice;
        return $this;
    }
    /**
     * Get NormalBasePriceWithOptionsAndBookingFees value
     * @return float
     */
    public function getNormalBasePriceWithOptionsAndBookingFees()
    {
        return $this->NormalBasePriceWithOptionsAndBookingFees;
    }
    /**
     * Set NormalBasePriceWithOptionsAndBookingFees value
     * @param float $normalBasePriceWithOptionsAndBookingFees
     * @return \StructType\TunnelCartPrices
     */
    public function setNormalBasePriceWithOptionsAndBookingFees($normalBasePriceWithOptionsAndBookingFees = null)
    {
        // validation for constraint: float
        if (!is_null($normalBasePriceWithOptionsAndBookingFees) && !(is_float($normalBasePriceWithOptionsAndBookingFees) || is_numeric($normalBasePriceWithOptionsAndBookingFees))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($normalBasePriceWithOptionsAndBookingFees, true), gettype($normalBasePriceWithOptionsAndBookingFees)), __LINE__);
        }
        $this->NormalBasePriceWithOptionsAndBookingFees = $normalBasePriceWithOptionsAndBookingFees;
        return $this;
    }
    /**
     * Get DiscountBasePriceWithOptionsAndBookingFees value
     * @return float
     */
    public function getDiscountBasePriceWithOptionsAndBookingFees()
    {
        return $this->DiscountBasePriceWithOptionsAndBookingFees;
    }
    /**
     * Set DiscountBasePriceWithOptionsAndBookingFees value
     * @param float $discountBasePriceWithOptionsAndBookingFees
     * @return \StructType\TunnelCartPrices
     */
    public function setDiscountBasePriceWithOptionsAndBookingFees($discountBasePriceWithOptionsAndBookingFees = null)
    {
        // validation for constraint: float
        if (!is_null($discountBasePriceWithOptionsAndBookingFees) && !(is_float($discountBasePriceWithOptionsAndBookingFees) || is_numeric($discountBasePriceWithOptionsAndBookingFees))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($discountBasePriceWithOptionsAndBookingFees, true), gettype($discountBasePriceWithOptionsAndBookingFees)), __LINE__);
        }
        $this->DiscountBasePriceWithOptionsAndBookingFees = $discountBasePriceWithOptionsAndBookingFees;
        return $this;
    }
    /**
     * Get PriceWithBookingFees value
     * @return float
     */
    public function getPriceWithBookingFees()
    {
        return $this->PriceWithBookingFees;
    }
    /**
     * Set PriceWithBookingFees value
     * @param float $priceWithBookingFees
     * @return \StructType\TunnelCartPrices
     */
    public function setPriceWithBookingFees($priceWithBookingFees = null)
    {
        // validation for constraint: float
        if (!is_null($priceWithBookingFees) && !(is_float($priceWithBookingFees) || is_numeric($priceWithBookingFees))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($priceWithBookingFees, true), gettype($priceWithBookingFees)), __LINE__);
        }
        $this->PriceWithBookingFees = $priceWithBookingFees;
        return $this;
    }
    /**
     * Get Currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->Currency;
    }
    /**
     * Set Currency value
     * @param string $currency
     * @return \StructType\TunnelCartPrices
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        $this->Currency = $currency;
        return $this;
    }
}
