<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for productWeekEndPrice StructType
 * @subpackage Structs
 */
class ProductWeekEndPrice extends AbstractStructBase
{
    /**
     * The dayOfWeek
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $dayOfWeek;
    /**
     * The price
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $price;
    /**
     * Constructor method for productWeekEndPrice
     * @uses ProductWeekEndPrice::setDayOfWeek()
     * @uses ProductWeekEndPrice::setPrice()
     * @param string $dayOfWeek
     * @param float $price
     */
    public function __construct($dayOfWeek = null, $price = null)
    {
        $this
            ->setDayOfWeek($dayOfWeek)
            ->setPrice($price);
    }
    /**
     * Get dayOfWeek value
     * @return string
     */
    public function getDayOfWeek()
    {
        return $this->dayOfWeek;
    }
    /**
     * Set dayOfWeek value
     * @uses \EnumType\DayOfWeek::valueIsValid()
     * @uses \EnumType\DayOfWeek::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dayOfWeek
     * @return \StructType\ProductWeekEndPrice
     */
    public function setDayOfWeek($dayOfWeek = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DayOfWeek::valueIsValid($dayOfWeek)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\DayOfWeek', is_array($dayOfWeek) ? implode(', ', $dayOfWeek) : var_export($dayOfWeek, true), implode(', ', \EnumType\DayOfWeek::getValidValues())), __LINE__);
        }
        $this->dayOfWeek = $dayOfWeek;
        return $this;
    }
    /**
     * Get price value
     * @return float
     */
    public function getPrice()
    {
        return $this->price;
    }
    /**
     * Set price value
     * @param float $price
     * @return \StructType\ProductWeekEndPrice
     */
    public function setPrice($price = null)
    {
        // validation for constraint: float
        if (!is_null($price) && !(is_float($price) || is_numeric($price))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($price, true), gettype($price)), __LINE__);
        }
        $this->price = $price;
        return $this;
    }
}
