<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Periode StructType
 * @subpackage Structs
 */
class Periode extends AbstractStructBase
{
    /**
     * The GeneralOSID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $GeneralOSID;
    /**
     * The DDIncluse
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DDIncluse;
    /**
     * The DFIncluse
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DFIncluse;
    /**
     * The DDValiditeIncluse
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $DDValiditeIncluse;
    /**
     * The DFValiditeIncluse
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $DFValiditeIncluse;
    /**
     * The NbDaysBeforeArrival
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $NbDaysBeforeArrival;
    /**
     * The FromNbDaysBeforeArrival
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $FromNbDaysBeforeArrival;
    /**
     * Constructor method for Periode
     * @uses Periode::setGeneralOSID()
     * @uses Periode::setDDIncluse()
     * @uses Periode::setDFIncluse()
     * @uses Periode::setDDValiditeIncluse()
     * @uses Periode::setDFValiditeIncluse()
     * @uses Periode::setNbDaysBeforeArrival()
     * @uses Periode::setFromNbDaysBeforeArrival()
     * @param int $generalOSID
     * @param string $dDIncluse
     * @param string $dFIncluse
     * @param string $dDValiditeIncluse
     * @param string $dFValiditeIncluse
     * @param int $nbDaysBeforeArrival
     * @param int $fromNbDaysBeforeArrival
     */
    public function __construct($generalOSID = null, $dDIncluse = null, $dFIncluse = null, $dDValiditeIncluse = null, $dFValiditeIncluse = null, $nbDaysBeforeArrival = null, $fromNbDaysBeforeArrival = null)
    {
        $this
            ->setGeneralOSID($generalOSID)
            ->setDDIncluse($dDIncluse)
            ->setDFIncluse($dFIncluse)
            ->setDDValiditeIncluse($dDValiditeIncluse)
            ->setDFValiditeIncluse($dFValiditeIncluse)
            ->setNbDaysBeforeArrival($nbDaysBeforeArrival)
            ->setFromNbDaysBeforeArrival($fromNbDaysBeforeArrival);
    }
    /**
     * Get GeneralOSID value
     * @return int
     */
    public function getGeneralOSID()
    {
        return $this->GeneralOSID;
    }
    /**
     * Set GeneralOSID value
     * @param int $generalOSID
     * @return \StructType\Periode
     */
    public function setGeneralOSID($generalOSID = null)
    {
        // validation for constraint: int
        if (!is_null($generalOSID) && !(is_int($generalOSID) || ctype_digit($generalOSID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($generalOSID, true), gettype($generalOSID)), __LINE__);
        }
        $this->GeneralOSID = $generalOSID;
        return $this;
    }
    /**
     * Get DDIncluse value
     * @return string
     */
    public function getDDIncluse()
    {
        return $this->DDIncluse;
    }
    /**
     * Set DDIncluse value
     * @param string $dDIncluse
     * @return \StructType\Periode
     */
    public function setDDIncluse($dDIncluse = null)
    {
        // validation for constraint: string
        if (!is_null($dDIncluse) && !is_string($dDIncluse)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dDIncluse, true), gettype($dDIncluse)), __LINE__);
        }
        $this->DDIncluse = $dDIncluse;
        return $this;
    }
    /**
     * Get DFIncluse value
     * @return string
     */
    public function getDFIncluse()
    {
        return $this->DFIncluse;
    }
    /**
     * Set DFIncluse value
     * @param string $dFIncluse
     * @return \StructType\Periode
     */
    public function setDFIncluse($dFIncluse = null)
    {
        // validation for constraint: string
        if (!is_null($dFIncluse) && !is_string($dFIncluse)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dFIncluse, true), gettype($dFIncluse)), __LINE__);
        }
        $this->DFIncluse = $dFIncluse;
        return $this;
    }
    /**
     * Get DDValiditeIncluse value
     * @return string
     */
    public function getDDValiditeIncluse()
    {
        return $this->DDValiditeIncluse;
    }
    /**
     * Set DDValiditeIncluse value
     * @param string $dDValiditeIncluse
     * @return \StructType\Periode
     */
    public function setDDValiditeIncluse($dDValiditeIncluse = null)
    {
        // validation for constraint: string
        if (!is_null($dDValiditeIncluse) && !is_string($dDValiditeIncluse)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dDValiditeIncluse, true), gettype($dDValiditeIncluse)), __LINE__);
        }
        $this->DDValiditeIncluse = $dDValiditeIncluse;
        return $this;
    }
    /**
     * Get DFValiditeIncluse value
     * @return string
     */
    public function getDFValiditeIncluse()
    {
        return $this->DFValiditeIncluse;
    }
    /**
     * Set DFValiditeIncluse value
     * @param string $dFValiditeIncluse
     * @return \StructType\Periode
     */
    public function setDFValiditeIncluse($dFValiditeIncluse = null)
    {
        // validation for constraint: string
        if (!is_null($dFValiditeIncluse) && !is_string($dFValiditeIncluse)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dFValiditeIncluse, true), gettype($dFValiditeIncluse)), __LINE__);
        }
        $this->DFValiditeIncluse = $dFValiditeIncluse;
        return $this;
    }
    /**
     * Get NbDaysBeforeArrival value
     * @return int
     */
    public function getNbDaysBeforeArrival()
    {
        return $this->NbDaysBeforeArrival;
    }
    /**
     * Set NbDaysBeforeArrival value
     * @param int $nbDaysBeforeArrival
     * @return \StructType\Periode
     */
    public function setNbDaysBeforeArrival($nbDaysBeforeArrival = null)
    {
        // validation for constraint: int
        if (!is_null($nbDaysBeforeArrival) && !(is_int($nbDaysBeforeArrival) || ctype_digit($nbDaysBeforeArrival))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($nbDaysBeforeArrival, true), gettype($nbDaysBeforeArrival)), __LINE__);
        }
        $this->NbDaysBeforeArrival = $nbDaysBeforeArrival;
        return $this;
    }
    /**
     * Get FromNbDaysBeforeArrival value
     * @return int
     */
    public function getFromNbDaysBeforeArrival()
    {
        return $this->FromNbDaysBeforeArrival;
    }
    /**
     * Set FromNbDaysBeforeArrival value
     * @param int $fromNbDaysBeforeArrival
     * @return \StructType\Periode
     */
    public function setFromNbDaysBeforeArrival($fromNbDaysBeforeArrival = null)
    {
        // validation for constraint: int
        if (!is_null($fromNbDaysBeforeArrival) && !(is_int($fromNbDaysBeforeArrival) || ctype_digit($fromNbDaysBeforeArrival))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($fromNbDaysBeforeArrival, true), gettype($fromNbDaysBeforeArrival)), __LINE__);
        }
        $this->FromNbDaysBeforeArrival = $fromNbDaysBeforeArrival;
        return $this;
    }
}
