<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfInt1 ArrayType
 * @subpackage Arrays
 */
class ArrayOfInt1 extends AbstractStructArrayBase
{
    /**
     * The idOffer
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var int[]
     */
    public $idOffer;
    /**
     * Constructor method for ArrayOfInt1
     * @uses ArrayOfInt1::setIdOffer()
     * @param int[] $idOffer
     */
    public function __construct(array $idOffer = array())
    {
        $this
            ->setIdOffer($idOffer);
    }
    /**
     * Get idOffer value
     * @return int[]|null
     */
    public function getIdOffer()
    {
        return $this->idOffer;
    }
    /**
     * This method is responsible for validating the values passed to the setIdOffer method
     * This method is willingly generated in order to preserve the one-line inline validation within the setIdOffer method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateIdOfferForArrayConstraintsFromSetIdOffer(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfInt1IdOfferItem) {
            // validation for constraint: itemType
            if (!(is_int($arrayOfInt1IdOfferItem) || ctype_digit($arrayOfInt1IdOfferItem))) {
                $invalidValues[] = is_object($arrayOfInt1IdOfferItem) ? get_class($arrayOfInt1IdOfferItem) : sprintf('%s(%s)', gettype($arrayOfInt1IdOfferItem), var_export($arrayOfInt1IdOfferItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The idOffer property can only contain items of type int, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set idOffer value
     * @throws \InvalidArgumentException
     * @param int[] $idOffer
     * @return \ArrayType\ArrayOfInt1
     */
    public function setIdOffer(array $idOffer = array())
    {
        // validation for constraint: array
        if ('' !== ($idOfferArrayErrorMessage = self::validateIdOfferForArrayConstraintsFromSetIdOffer($idOffer))) {
            throw new \InvalidArgumentException($idOfferArrayErrorMessage, __LINE__);
        }
        $this->idOffer = $idOffer;
        return $this;
    }
    /**
     * Add item to idOffer value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \ArrayType\ArrayOfInt1
     */
    public function addToIdOffer($item)
    {
        // validation for constraint: itemType
        if (!(is_int($item) || ctype_digit($item))) {
            throw new \InvalidArgumentException(sprintf('The idOffer property can only contain items of type int, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->idOffer[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return int|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return int|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return int|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return int|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return int|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string idOffer
     */
    public function getAttributeName()
    {
        return 'idOffer';
    }
}
