<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GeneralOfferInformation StructType
 * @subpackage Structs
 */
class GeneralOfferInformation extends AbstractStructBase
{
    /**
     * The GeneralOSID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $GeneralOSID;
    /**
     * The DateCreation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DateCreation;
    /**
     * The DateModification
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $DateModification;
    /**
     * The DomaineApplication
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $DomaineApplication;
    /**
     * The IsCachee
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsCachee;
    /**
     * The WithEstablishmentsWithoutProduct
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $WithEstablishmentsWithoutProduct;
    /**
     * The Court
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Court;
    /**
     * The Long
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Long;
    /**
     * The LibelleAuto
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LibelleAuto;
    /**
     * The CodageOS
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OfferCodage
     */
    public $CodageOS;
    /**
     * The Commission
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OfferCommission
     */
    public $Commission;
    /**
     * The Person
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Person
     */
    public $Person;
    /**
     * The Account
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OfferAccount
     */
    public $Account;
    /**
     * The BookingFees
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OfferBookingFees
     */
    public $BookingFees;
    /**
     * The StayDuration
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\StayDuration
     */
    public $StayDuration;
    /**
     * The ReductionSemaineList
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfInt
     */
    public $ReductionSemaineList;
    /**
     * Constructor method for GeneralOfferInformation
     * @uses GeneralOfferInformation::setGeneralOSID()
     * @uses GeneralOfferInformation::setDateCreation()
     * @uses GeneralOfferInformation::setDateModification()
     * @uses GeneralOfferInformation::setDomaineApplication()
     * @uses GeneralOfferInformation::setIsCachee()
     * @uses GeneralOfferInformation::setWithEstablishmentsWithoutProduct()
     * @uses GeneralOfferInformation::setCourt()
     * @uses GeneralOfferInformation::setLong()
     * @uses GeneralOfferInformation::setLibelleAuto()
     * @uses GeneralOfferInformation::setCodageOS()
     * @uses GeneralOfferInformation::setCommission()
     * @uses GeneralOfferInformation::setPerson()
     * @uses GeneralOfferInformation::setAccount()
     * @uses GeneralOfferInformation::setBookingFees()
     * @uses GeneralOfferInformation::setStayDuration()
     * @uses GeneralOfferInformation::setReductionSemaineList()
     * @param int $generalOSID
     * @param string $dateCreation
     * @param string $dateModification
     * @param string $domaineApplication
     * @param bool $isCachee
     * @param bool $withEstablishmentsWithoutProduct
     * @param string $court
     * @param string $long
     * @param string $libelleAuto
     * @param \StructType\OfferCodage $codageOS
     * @param \StructType\OfferCommission $commission
     * @param \StructType\Person $person
     * @param \StructType\OfferAccount $account
     * @param \StructType\OfferBookingFees $bookingFees
     * @param \StructType\StayDuration $stayDuration
     * @param \ArrayType\ArrayOfInt $reductionSemaineList
     */
    public function __construct($generalOSID = null, $dateCreation = null, $dateModification = null, $domaineApplication = null, $isCachee = null, $withEstablishmentsWithoutProduct = null, $court = null, $long = null, $libelleAuto = null, \StructType\OfferCodage $codageOS = null, \StructType\OfferCommission $commission = null, \StructType\Person $person = null, \StructType\OfferAccount $account = null, \StructType\OfferBookingFees $bookingFees = null, \StructType\StayDuration $stayDuration = null, \ArrayType\ArrayOfInt $reductionSemaineList = null)
    {
        $this
            ->setGeneralOSID($generalOSID)
            ->setDateCreation($dateCreation)
            ->setDateModification($dateModification)
            ->setDomaineApplication($domaineApplication)
            ->setIsCachee($isCachee)
            ->setWithEstablishmentsWithoutProduct($withEstablishmentsWithoutProduct)
            ->setCourt($court)
            ->setLong($long)
            ->setLibelleAuto($libelleAuto)
            ->setCodageOS($codageOS)
            ->setCommission($commission)
            ->setPerson($person)
            ->setAccount($account)
            ->setBookingFees($bookingFees)
            ->setStayDuration($stayDuration)
            ->setReductionSemaineList($reductionSemaineList);
    }
    /**
     * Get GeneralOSID value
     * @return int
     */
    public function getGeneralOSID()
    {
        return $this->GeneralOSID;
    }
    /**
     * Set GeneralOSID value
     * @param int $generalOSID
     * @return \StructType\GeneralOfferInformation
     */
    public function setGeneralOSID($generalOSID = null)
    {
        // validation for constraint: int
        if (!is_null($generalOSID) && !(is_int($generalOSID) || ctype_digit($generalOSID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($generalOSID, true), gettype($generalOSID)), __LINE__);
        }
        $this->GeneralOSID = $generalOSID;
        return $this;
    }
    /**
     * Get DateCreation value
     * @return string
     */
    public function getDateCreation()
    {
        return $this->DateCreation;
    }
    /**
     * Set DateCreation value
     * @param string $dateCreation
     * @return \StructType\GeneralOfferInformation
     */
    public function setDateCreation($dateCreation = null)
    {
        // validation for constraint: string
        if (!is_null($dateCreation) && !is_string($dateCreation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateCreation, true), gettype($dateCreation)), __LINE__);
        }
        $this->DateCreation = $dateCreation;
        return $this;
    }
    /**
     * Get DateModification value
     * @return string
     */
    public function getDateModification()
    {
        return $this->DateModification;
    }
    /**
     * Set DateModification value
     * @param string $dateModification
     * @return \StructType\GeneralOfferInformation
     */
    public function setDateModification($dateModification = null)
    {
        // validation for constraint: string
        if (!is_null($dateModification) && !is_string($dateModification)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateModification, true), gettype($dateModification)), __LINE__);
        }
        $this->DateModification = $dateModification;
        return $this;
    }
    /**
     * Get DomaineApplication value
     * @return string
     */
    public function getDomaineApplication()
    {
        return $this->DomaineApplication;
    }
    /**
     * Set DomaineApplication value
     * @uses \EnumType\DomaineApplication::valueIsValid()
     * @uses \EnumType\DomaineApplication::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $domaineApplication
     * @return \StructType\GeneralOfferInformation
     */
    public function setDomaineApplication($domaineApplication = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DomaineApplication::valueIsValid($domaineApplication)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\DomaineApplication', is_array($domaineApplication) ? implode(', ', $domaineApplication) : var_export($domaineApplication, true), implode(', ', \EnumType\DomaineApplication::getValidValues())), __LINE__);
        }
        $this->DomaineApplication = $domaineApplication;
        return $this;
    }
    /**
     * Get IsCachee value
     * @return bool
     */
    public function getIsCachee()
    {
        return $this->IsCachee;
    }
    /**
     * Set IsCachee value
     * @param bool $isCachee
     * @return \StructType\GeneralOfferInformation
     */
    public function setIsCachee($isCachee = null)
    {
        // validation for constraint: boolean
        if (!is_null($isCachee) && !is_bool($isCachee)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isCachee, true), gettype($isCachee)), __LINE__);
        }
        $this->IsCachee = $isCachee;
        return $this;
    }
    /**
     * Get WithEstablishmentsWithoutProduct value
     * @return bool
     */
    public function getWithEstablishmentsWithoutProduct()
    {
        return $this->WithEstablishmentsWithoutProduct;
    }
    /**
     * Set WithEstablishmentsWithoutProduct value
     * @param bool $withEstablishmentsWithoutProduct
     * @return \StructType\GeneralOfferInformation
     */
    public function setWithEstablishmentsWithoutProduct($withEstablishmentsWithoutProduct = null)
    {
        // validation for constraint: boolean
        if (!is_null($withEstablishmentsWithoutProduct) && !is_bool($withEstablishmentsWithoutProduct)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($withEstablishmentsWithoutProduct, true), gettype($withEstablishmentsWithoutProduct)), __LINE__);
        }
        $this->WithEstablishmentsWithoutProduct = $withEstablishmentsWithoutProduct;
        return $this;
    }
    /**
     * Get Court value
     * @return string|null
     */
    public function getCourt()
    {
        return $this->Court;
    }
    /**
     * Set Court value
     * @param string $court
     * @return \StructType\GeneralOfferInformation
     */
    public function setCourt($court = null)
    {
        // validation for constraint: string
        if (!is_null($court) && !is_string($court)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($court, true), gettype($court)), __LINE__);
        }
        $this->Court = $court;
        return $this;
    }
    /**
     * Get Long value
     * @return string|null
     */
    public function getLong()
    {
        return $this->Long;
    }
    /**
     * Set Long value
     * @param string $long
     * @return \StructType\GeneralOfferInformation
     */
    public function setLong($long = null)
    {
        // validation for constraint: string
        if (!is_null($long) && !is_string($long)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($long, true), gettype($long)), __LINE__);
        }
        $this->Long = $long;
        return $this;
    }
    /**
     * Get LibelleAuto value
     * @return string|null
     */
    public function getLibelleAuto()
    {
        return $this->LibelleAuto;
    }
    /**
     * Set LibelleAuto value
     * @param string $libelleAuto
     * @return \StructType\GeneralOfferInformation
     */
    public function setLibelleAuto($libelleAuto = null)
    {
        // validation for constraint: string
        if (!is_null($libelleAuto) && !is_string($libelleAuto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($libelleAuto, true), gettype($libelleAuto)), __LINE__);
        }
        $this->LibelleAuto = $libelleAuto;
        return $this;
    }
    /**
     * Get CodageOS value
     * @return \StructType\OfferCodage|null
     */
    public function getCodageOS()
    {
        return $this->CodageOS;
    }
    /**
     * Set CodageOS value
     * @param \StructType\OfferCodage $codageOS
     * @return \StructType\GeneralOfferInformation
     */
    public function setCodageOS(\StructType\OfferCodage $codageOS = null)
    {
        $this->CodageOS = $codageOS;
        return $this;
    }
    /**
     * Get Commission value
     * @return \StructType\OfferCommission|null
     */
    public function getCommission()
    {
        return $this->Commission;
    }
    /**
     * Set Commission value
     * @param \StructType\OfferCommission $commission
     * @return \StructType\GeneralOfferInformation
     */
    public function setCommission(\StructType\OfferCommission $commission = null)
    {
        $this->Commission = $commission;
        return $this;
    }
    /**
     * Get Person value
     * @return \StructType\Person|null
     */
    public function getPerson()
    {
        return $this->Person;
    }
    /**
     * Set Person value
     * @param \StructType\Person $person
     * @return \StructType\GeneralOfferInformation
     */
    public function setPerson(\StructType\Person $person = null)
    {
        $this->Person = $person;
        return $this;
    }
    /**
     * Get Account value
     * @return \StructType\OfferAccount|null
     */
    public function getAccount()
    {
        return $this->Account;
    }
    /**
     * Set Account value
     * @param \StructType\OfferAccount $account
     * @return \StructType\GeneralOfferInformation
     */
    public function setAccount(\StructType\OfferAccount $account = null)
    {
        $this->Account = $account;
        return $this;
    }
    /**
     * Get BookingFees value
     * @return \StructType\OfferBookingFees|null
     */
    public function getBookingFees()
    {
        return $this->BookingFees;
    }
    /**
     * Set BookingFees value
     * @param \StructType\OfferBookingFees $bookingFees
     * @return \StructType\GeneralOfferInformation
     */
    public function setBookingFees(\StructType\OfferBookingFees $bookingFees = null)
    {
        $this->BookingFees = $bookingFees;
        return $this;
    }
    /**
     * Get StayDuration value
     * @return \StructType\StayDuration|null
     */
    public function getStayDuration()
    {
        return $this->StayDuration;
    }
    /**
     * Set StayDuration value
     * @param \StructType\StayDuration $stayDuration
     * @return \StructType\GeneralOfferInformation
     */
    public function setStayDuration(\StructType\StayDuration $stayDuration = null)
    {
        $this->StayDuration = $stayDuration;
        return $this;
    }
    /**
     * Get ReductionSemaineList value
     * @return \ArrayType\ArrayOfInt|null
     */
    public function getReductionSemaineList()
    {
        return $this->ReductionSemaineList;
    }
    /**
     * Set ReductionSemaineList value
     * @param \ArrayType\ArrayOfInt $reductionSemaineList
     * @return \StructType\GeneralOfferInformation
     */
    public function setReductionSemaineList(\ArrayType\ArrayOfInt $reductionSemaineList = null)
    {
        $this->ReductionSemaineList = $reductionSemaineList;
        return $this;
    }
}
