<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EstablishmentPaymentMean StructType
 * @subpackage Structs
 */
class EstablishmentPaymentMean extends AbstractStructBase
{
    /**
     * The SuspendedAtXDaysBeforeArrival
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $SuspendedAtXDaysBeforeArrival;
    /**
     * The CustomerCountryCodes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString
     */
    public $CustomerCountryCodes;
    /**
     * The SuspensionDates
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfPaymentMeanSuspensionDate
     */
    public $SuspensionDates;
    /**
     * The SuspendedUntil
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SuspendedUntil;
    /**
     * The Name
     * @var string
     */
    public $Name;
    /**
     * The Id
     * @var string
     */
    public $Id;
    /**
     * Constructor method for EstablishmentPaymentMean
     * @uses EstablishmentPaymentMean::setSuspendedAtXDaysBeforeArrival()
     * @uses EstablishmentPaymentMean::setCustomerCountryCodes()
     * @uses EstablishmentPaymentMean::setSuspensionDates()
     * @uses EstablishmentPaymentMean::setSuspendedUntil()
     * @uses EstablishmentPaymentMean::setName()
     * @uses EstablishmentPaymentMean::setId()
     * @param int $suspendedAtXDaysBeforeArrival
     * @param \ArrayType\ArrayOfString $customerCountryCodes
     * @param \ArrayType\ArrayOfPaymentMeanSuspensionDate $suspensionDates
     * @param string $suspendedUntil
     * @param string $name
     * @param string $id
     */
    public function __construct($suspendedAtXDaysBeforeArrival = null, \ArrayType\ArrayOfString $customerCountryCodes = null, \ArrayType\ArrayOfPaymentMeanSuspensionDate $suspensionDates = null, $suspendedUntil = null, $name = null, $id = null)
    {
        $this
            ->setSuspendedAtXDaysBeforeArrival($suspendedAtXDaysBeforeArrival)
            ->setCustomerCountryCodes($customerCountryCodes)
            ->setSuspensionDates($suspensionDates)
            ->setSuspendedUntil($suspendedUntil)
            ->setName($name)
            ->setId($id);
    }
    /**
     * Get SuspendedAtXDaysBeforeArrival value
     * @return int
     */
    public function getSuspendedAtXDaysBeforeArrival()
    {
        return $this->SuspendedAtXDaysBeforeArrival;
    }
    /**
     * Set SuspendedAtXDaysBeforeArrival value
     * @param int $suspendedAtXDaysBeforeArrival
     * @return \StructType\EstablishmentPaymentMean
     */
    public function setSuspendedAtXDaysBeforeArrival($suspendedAtXDaysBeforeArrival = null)
    {
        // validation for constraint: int
        if (!is_null($suspendedAtXDaysBeforeArrival) && !(is_int($suspendedAtXDaysBeforeArrival) || ctype_digit($suspendedAtXDaysBeforeArrival))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($suspendedAtXDaysBeforeArrival, true), gettype($suspendedAtXDaysBeforeArrival)), __LINE__);
        }
        $this->SuspendedAtXDaysBeforeArrival = $suspendedAtXDaysBeforeArrival;
        return $this;
    }
    /**
     * Get CustomerCountryCodes value
     * @return \ArrayType\ArrayOfString|null
     */
    public function getCustomerCountryCodes()
    {
        return $this->CustomerCountryCodes;
    }
    /**
     * Set CustomerCountryCodes value
     * @param \ArrayType\ArrayOfString $customerCountryCodes
     * @return \StructType\EstablishmentPaymentMean
     */
    public function setCustomerCountryCodes(\ArrayType\ArrayOfString $customerCountryCodes = null)
    {
        $this->CustomerCountryCodes = $customerCountryCodes;
        return $this;
    }
    /**
     * Get SuspensionDates value
     * @return \ArrayType\ArrayOfPaymentMeanSuspensionDate|null
     */
    public function getSuspensionDates()
    {
        return $this->SuspensionDates;
    }
    /**
     * Set SuspensionDates value
     * @param \ArrayType\ArrayOfPaymentMeanSuspensionDate $suspensionDates
     * @return \StructType\EstablishmentPaymentMean
     */
    public function setSuspensionDates(\ArrayType\ArrayOfPaymentMeanSuspensionDate $suspensionDates = null)
    {
        $this->SuspensionDates = $suspensionDates;
        return $this;
    }
    /**
     * Get SuspendedUntil value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSuspendedUntil()
    {
        return isset($this->SuspendedUntil) ? $this->SuspendedUntil : null;
    }
    /**
     * Set SuspendedUntil value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $suspendedUntil
     * @return \StructType\EstablishmentPaymentMean
     */
    public function setSuspendedUntil($suspendedUntil = null)
    {
        // validation for constraint: string
        if (!is_null($suspendedUntil) && !is_string($suspendedUntil)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($suspendedUntil, true), gettype($suspendedUntil)), __LINE__);
        }
        if (is_null($suspendedUntil) || (is_array($suspendedUntil) && empty($suspendedUntil))) {
            unset($this->SuspendedUntil);
        } else {
            $this->SuspendedUntil = $suspendedUntil;
        }
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\EstablishmentPaymentMean
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \StructType\EstablishmentPaymentMean
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
}
