<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetLastMinuteOffers
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetLastMinuteOffers $parameters
     * @return \StructType\GetLastMinuteOffersResponse|bool
     */
    public function GetLastMinuteOffers(\StructType\GetLastMinuteOffers $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetLastMinuteOffers($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetProductsPlanning
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetProductsPlanning $parameters
     * @return \StructType\GetProductsPlanningResponse|bool
     */
    public function GetProductsPlanning(\StructType\GetProductsPlanning $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetProductsPlanning($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetStartingFromPriceList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetStartingFromPriceList $parameters
     * @return \StructType\GetStartingFromPriceListResponse|bool
     */
    public function GetStartingFromPriceList(\StructType\GetStartingFromPriceList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetStartingFromPriceList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAbandonementCart
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAbandonementCart $parameters
     * @return \StructType\GetAbandonementCartResponse|bool
     */
    public function GetAbandonementCart(\StructType\GetAbandonementCart $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAbandonementCart($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetStartingFromPriceFile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetStartingFromPriceFile $parameters
     * @return \StructType\GetStartingFromPriceFileResponse|bool
     */
    public function GetStartingFromPriceFile(\StructType\GetStartingFromPriceFile $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetStartingFromPriceFile($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetInjectedOffers
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetInjectedOffers $parameters
     * @return \StructType\GetInjectedOffersResponse|bool
     */
    public function GetInjectedOffers(\StructType\GetInjectedOffers $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetInjectedOffers($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetIncreasedPricesInformationList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetIncreasedPricesInformationList $parameters
     * @return \StructType\GetIncreasedPricesInformationListResponse|bool
     */
    public function GetIncreasedPricesInformationList(\StructType\GetIncreasedPricesInformationList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetIncreasedPricesInformationList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetQuote
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetQuote $parameters
     * @return \StructType\GetQuoteResponse|bool
     */
    public function GetQuote(\StructType\GetQuote $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetQuote($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getEntityTypeAttributes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetEntityTypeAttributes $parameters
     * @return \StructType\GetEntityTypeAttributesResponse|bool
     */
    public function getEntityTypeAttributes(\StructType\GetEntityTypeAttributes $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getEntityTypeAttributes($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetEstablishmentInformations
     * Meta information extracted from the WSDL
     * - documentation: Get establishment's features, photos, products' inventory and photos.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetEstablishmentInformations $parameters
     * @return \StructType\GetEstablishmentInformationsResponse|bool
     */
    public function GetEstablishmentInformations(\StructType\GetEstablishmentInformations $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetEstablishmentInformations($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetEstablishmentPhotos
     * Meta information extracted from the WSDL
     * - documentation: Get establishments' photos.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetEstablishmentPhotos $parameters
     * @return \StructType\GetEstablishmentPhotosResponse|bool
     */
    public function GetEstablishmentPhotos(\StructType\GetEstablishmentPhotos $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetEstablishmentPhotos($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetActiveKeysFromEngine
     * Meta information extracted from the WSDL
     * - documentation: Get establishments and products keys and the last time their informations were updated.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetActiveKeysFromEngine $parameters
     * @return \StructType\GetActiveKeysFromEngineResponse|bool
     */
    public function GetActiveKeysFromEngine(\StructType\GetActiveKeysFromEngine $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetActiveKeysFromEngine($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCatalogue
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCatalogue $parameters
     * @return \StructType\GetCatalogueResponse|bool
     */
    public function GetCatalogue(\StructType\GetCatalogue $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCatalogue($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetAbandonementCartResponse|\StructType\GetActiveKeysFromEngineResponse|\StructType\GetCatalogueResponse|\StructType\GetEntityTypeAttributesResponse|\StructType\GetEstablishmentInformationsResponse|\StructType\GetEstablishmentPhotosResponse|\StructType\GetIncreasedPricesInformationListResponse|\StructType\GetInjectedOffersResponse|\StructType\GetLastMinuteOffersResponse|\StructType\GetProductsPlanningResponse|\StructType\GetQuoteResponse|\StructType\GetStartingFromPriceFileResponse|\StructType\GetStartingFromPriceListResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
