<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OfferCommission StructType
 * @subpackage Structs
 */
class OfferCommission extends AbstractStructBase
{
    /**
     * The CommissionAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $CommissionAmount;
    /**
     * The CommissionUniteEnum
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CommissionUniteEnum;
    /**
     * Constructor method for OfferCommission
     * @uses OfferCommission::setCommissionAmount()
     * @uses OfferCommission::setCommissionUniteEnum()
     * @param float $commissionAmount
     * @param string $commissionUniteEnum
     */
    public function __construct($commissionAmount = null, $commissionUniteEnum = null)
    {
        $this
            ->setCommissionAmount($commissionAmount)
            ->setCommissionUniteEnum($commissionUniteEnum);
    }
    /**
     * Get CommissionAmount value
     * @return float
     */
    public function getCommissionAmount()
    {
        return $this->CommissionAmount;
    }
    /**
     * Set CommissionAmount value
     * @param float $commissionAmount
     * @return \StructType\OfferCommission
     */
    public function setCommissionAmount($commissionAmount = null)
    {
        // validation for constraint: float
        if (!is_null($commissionAmount) && !(is_float($commissionAmount) || is_numeric($commissionAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($commissionAmount, true), gettype($commissionAmount)), __LINE__);
        }
        $this->CommissionAmount = $commissionAmount;
        return $this;
    }
    /**
     * Get CommissionUniteEnum value
     * @return string
     */
    public function getCommissionUniteEnum()
    {
        return $this->CommissionUniteEnum;
    }
    /**
     * Set CommissionUniteEnum value
     * @uses \EnumType\CommissionUniteEnum::valueIsValid()
     * @uses \EnumType\CommissionUniteEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $commissionUniteEnum
     * @return \StructType\OfferCommission
     */
    public function setCommissionUniteEnum($commissionUniteEnum = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CommissionUniteEnum::valueIsValid($commissionUniteEnum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CommissionUniteEnum', is_array($commissionUniteEnum) ? implode(', ', $commissionUniteEnum) : var_export($commissionUniteEnum, true), implode(', ', \EnumType\CommissionUniteEnum::getValidValues())), __LINE__);
        }
        $this->CommissionUniteEnum = $commissionUniteEnum;
        return $this;
    }
}
