<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetInjectedOffers StructType
 * @subpackage Structs
 */
class GetInjectedOffers extends AbstractStructBase
{
    /**
     * The lang
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $lang;
    /**
     * The rankingProjectId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $rankingProjectId;
    /**
     * The loadPeriodsList
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $loadPeriodsList;
    /**
     * The User
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\WSUser
     */
    public $User;
    /**
     * The GeneralOSFilter
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\FilterOffreInjectee
     */
    public $GeneralOSFilter;
    /**
     * Constructor method for GetInjectedOffers
     * @uses GetInjectedOffers::setLang()
     * @uses GetInjectedOffers::setRankingProjectId()
     * @uses GetInjectedOffers::setLoadPeriodsList()
     * @uses GetInjectedOffers::setUser()
     * @uses GetInjectedOffers::setGeneralOSFilter()
     * @param string $lang
     * @param int $rankingProjectId
     * @param bool $loadPeriodsList
     * @param \StructType\WSUser $user
     * @param \StructType\FilterOffreInjectee $generalOSFilter
     */
    public function __construct($lang = null, $rankingProjectId = null, $loadPeriodsList = null, \StructType\WSUser $user = null, \StructType\FilterOffreInjectee $generalOSFilter = null)
    {
        $this
            ->setLang($lang)
            ->setRankingProjectId($rankingProjectId)
            ->setLoadPeriodsList($loadPeriodsList)
            ->setUser($user)
            ->setGeneralOSFilter($generalOSFilter);
    }
    /**
     * Get lang value
     * @return string
     */
    public function getLang()
    {
        return $this->lang;
    }
    /**
     * Set lang value
     * @uses \EnumType\Lang::valueIsValid()
     * @uses \EnumType\Lang::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $lang
     * @return \StructType\GetInjectedOffers
     */
    public function setLang($lang = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Lang::valueIsValid($lang)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Lang', is_array($lang) ? implode(', ', $lang) : var_export($lang, true), implode(', ', \EnumType\Lang::getValidValues())), __LINE__);
        }
        $this->lang = $lang;
        return $this;
    }
    /**
     * Get rankingProjectId value
     * @return int
     */
    public function getRankingProjectId()
    {
        return $this->rankingProjectId;
    }
    /**
     * Set rankingProjectId value
     * @param int $rankingProjectId
     * @return \StructType\GetInjectedOffers
     */
    public function setRankingProjectId($rankingProjectId = null)
    {
        // validation for constraint: int
        if (!is_null($rankingProjectId) && !(is_int($rankingProjectId) || ctype_digit($rankingProjectId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($rankingProjectId, true), gettype($rankingProjectId)), __LINE__);
        }
        $this->rankingProjectId = $rankingProjectId;
        return $this;
    }
    /**
     * Get loadPeriodsList value
     * @return bool
     */
    public function getLoadPeriodsList()
    {
        return $this->loadPeriodsList;
    }
    /**
     * Set loadPeriodsList value
     * @param bool $loadPeriodsList
     * @return \StructType\GetInjectedOffers
     */
    public function setLoadPeriodsList($loadPeriodsList = null)
    {
        // validation for constraint: boolean
        if (!is_null($loadPeriodsList) && !is_bool($loadPeriodsList)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($loadPeriodsList, true), gettype($loadPeriodsList)), __LINE__);
        }
        $this->loadPeriodsList = $loadPeriodsList;
        return $this;
    }
    /**
     * Get User value
     * @return \StructType\WSUser|null
     */
    public function getUser()
    {
        return $this->User;
    }
    /**
     * Set User value
     * @param \StructType\WSUser $user
     * @return \StructType\GetInjectedOffers
     */
    public function setUser(\StructType\WSUser $user = null)
    {
        $this->User = $user;
        return $this;
    }
    /**
     * Get GeneralOSFilter value
     * @return \StructType\FilterOffreInjectee|null
     */
    public function getGeneralOSFilter()
    {
        return $this->GeneralOSFilter;
    }
    /**
     * Set GeneralOSFilter value
     * @param \StructType\FilterOffreInjectee $generalOSFilter
     * @return \StructType\GetInjectedOffers
     */
    public function setGeneralOSFilter(\StructType\FilterOffreInjectee $generalOSFilter = null)
    {
        $this->GeneralOSFilter = $generalOSFilter;
        return $this;
    }
}
