<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for entityInfo StructType
 * @subpackage Structs
 */
class EntityInfo extends BaseEntityInfo
{
    /**
     * The mySortNumber
     * Meta information extracted from the WSDL
     * - use: required
     * @var int
     */
    public $mySortNumber;
    /**
     * The myFeatures
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ItemInfo[]
     */
    public $myFeatures;
    /**
     * Constructor method for entityInfo
     * @uses EntityInfo::setMySortNumber()
     * @uses EntityInfo::setMyFeatures()
     * @param int $mySortNumber
     * @param \StructType\ItemInfo[] $myFeatures
     */
    public function __construct($mySortNumber = null, array $myFeatures = array())
    {
        $this
            ->setMySortNumber($mySortNumber)
            ->setMyFeatures($myFeatures);
    }
    /**
     * Get mySortNumber value
     * @return int
     */
    public function getMySortNumber()
    {
        return $this->mySortNumber;
    }
    /**
     * Set mySortNumber value
     * @param int $mySortNumber
     * @return \StructType\EntityInfo
     */
    public function setMySortNumber($mySortNumber = null)
    {
        // validation for constraint: int
        if (!is_null($mySortNumber) && !(is_int($mySortNumber) || ctype_digit($mySortNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($mySortNumber, true), gettype($mySortNumber)), __LINE__);
        }
        $this->mySortNumber = $mySortNumber;
        return $this;
    }
    /**
     * Get myFeatures value
     * @return \StructType\ItemInfo[]|null
     */
    public function getMyFeatures()
    {
        return $this->myFeatures;
    }
    /**
     * This method is responsible for validating the values passed to the setMyFeatures method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMyFeatures method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMyFeaturesForArrayConstraintsFromSetMyFeatures(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $entityInfoMyFeaturesItem) {
            // validation for constraint: itemType
            if (!$entityInfoMyFeaturesItem instanceof \StructType\ItemInfo) {
                $invalidValues[] = is_object($entityInfoMyFeaturesItem) ? get_class($entityInfoMyFeaturesItem) : sprintf('%s(%s)', gettype($entityInfoMyFeaturesItem), var_export($entityInfoMyFeaturesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The myFeatures property can only contain items of type \StructType\ItemInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set myFeatures value
     * @throws \InvalidArgumentException
     * @param \StructType\ItemInfo[] $myFeatures
     * @return \StructType\EntityInfo
     */
    public function setMyFeatures(array $myFeatures = array())
    {
        // validation for constraint: array
        if ('' !== ($myFeaturesArrayErrorMessage = self::validateMyFeaturesForArrayConstraintsFromSetMyFeatures($myFeatures))) {
            throw new \InvalidArgumentException($myFeaturesArrayErrorMessage, __LINE__);
        }
        $this->myFeatures = $myFeatures;
        return $this;
    }
    /**
     * Add item to myFeatures value
     * @throws \InvalidArgumentException
     * @param \StructType\ItemInfo $item
     * @return \StructType\EntityInfo
     */
    public function addToMyFeatures(\StructType\ItemInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ItemInfo) {
            throw new \InvalidArgumentException(sprintf('The myFeatures property can only contain items of type \StructType\ItemInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->myFeatures[] = $item;
        return $this;
    }
}
