<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfEstablishment ArrayType
 * @subpackage Arrays
 */
class ArrayOfEstablishment extends AbstractStructArrayBase
{
    /**
     * The Establishment
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Establishment[]
     */
    public $Establishment;
    /**
     * Constructor method for ArrayOfEstablishment
     * @uses ArrayOfEstablishment::setEstablishment()
     * @param \StructType\Establishment[] $establishment
     */
    public function __construct(array $establishment = array())
    {
        $this
            ->setEstablishment($establishment);
    }
    /**
     * Get Establishment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Establishment[]|null
     */
    public function getEstablishment()
    {
        return isset($this->Establishment) ? $this->Establishment : null;
    }
    /**
     * This method is responsible for validating the values passed to the setEstablishment method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEstablishment method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEstablishmentForArrayConstraintsFromSetEstablishment(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfEstablishmentEstablishmentItem) {
            // validation for constraint: itemType
            if (!$arrayOfEstablishmentEstablishmentItem instanceof \StructType\Establishment) {
                $invalidValues[] = is_object($arrayOfEstablishmentEstablishmentItem) ? get_class($arrayOfEstablishmentEstablishmentItem) : sprintf('%s(%s)', gettype($arrayOfEstablishmentEstablishmentItem), var_export($arrayOfEstablishmentEstablishmentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Establishment property can only contain items of type \StructType\Establishment, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Establishment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Establishment[] $establishment
     * @return \ArrayType\ArrayOfEstablishment
     */
    public function setEstablishment(array $establishment = array())
    {
        // validation for constraint: array
        if ('' !== ($establishmentArrayErrorMessage = self::validateEstablishmentForArrayConstraintsFromSetEstablishment($establishment))) {
            throw new \InvalidArgumentException($establishmentArrayErrorMessage, __LINE__);
        }
        if (is_null($establishment) || (is_array($establishment) && empty($establishment))) {
            unset($this->Establishment);
        } else {
            $this->Establishment = $establishment;
        }
        return $this;
    }
    /**
     * Add item to Establishment value
     * @throws \InvalidArgumentException
     * @param \StructType\Establishment $item
     * @return \ArrayType\ArrayOfEstablishment
     */
    public function addToEstablishment(\StructType\Establishment $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Establishment) {
            throw new \InvalidArgumentException(sprintf('The Establishment property can only contain items of type \StructType\Establishment, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Establishment[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Establishment|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Establishment|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Establishment|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Establishment|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Establishment|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Establishment
     */
    public function getAttributeName()
    {
        return 'Establishment';
    }
}
