<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StayDuration StructType
 * @subpackage Structs
 */
class StayDuration extends AbstractStructBase
{
    /**
     * The MinNightsIncluded
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $MinNightsIncluded;
    /**
     * The MaxNightsIncluded
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $MaxNightsIncluded;
    /**
     * Constructor method for StayDuration
     * @uses StayDuration::setMinNightsIncluded()
     * @uses StayDuration::setMaxNightsIncluded()
     * @param int $minNightsIncluded
     * @param int $maxNightsIncluded
     */
    public function __construct($minNightsIncluded = null, $maxNightsIncluded = null)
    {
        $this
            ->setMinNightsIncluded($minNightsIncluded)
            ->setMaxNightsIncluded($maxNightsIncluded);
    }
    /**
     * Get MinNightsIncluded value
     * @return int
     */
    public function getMinNightsIncluded()
    {
        return $this->MinNightsIncluded;
    }
    /**
     * Set MinNightsIncluded value
     * @param int $minNightsIncluded
     * @return \StructType\StayDuration
     */
    public function setMinNightsIncluded($minNightsIncluded = null)
    {
        // validation for constraint: int
        if (!is_null($minNightsIncluded) && !(is_int($minNightsIncluded) || ctype_digit($minNightsIncluded))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($minNightsIncluded, true), gettype($minNightsIncluded)), __LINE__);
        }
        $this->MinNightsIncluded = $minNightsIncluded;
        return $this;
    }
    /**
     * Get MaxNightsIncluded value
     * @return int
     */
    public function getMaxNightsIncluded()
    {
        return $this->MaxNightsIncluded;
    }
    /**
     * Set MaxNightsIncluded value
     * @param int $maxNightsIncluded
     * @return \StructType\StayDuration
     */
    public function setMaxNightsIncluded($maxNightsIncluded = null)
    {
        // validation for constraint: int
        if (!is_null($maxNightsIncluded) && !(is_int($maxNightsIncluded) || ctype_digit($maxNightsIncluded))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxNightsIncluded, true), gettype($maxNightsIncluded)), __LINE__);
        }
        $this->MaxNightsIncluded = $maxNightsIncluded;
        return $this;
    }
}
