<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CompleteInfoProduct StructType
 * @subpackage Structs
 */
class CompleteInfoProduct extends AbstractStructBase
{
    /**
     * The photo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $photo;
    /**
     * The descriptionText
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $descriptionText;
    /**
     * Constructor method for CompleteInfoProduct
     * @uses CompleteInfoProduct::setPhoto()
     * @uses CompleteInfoProduct::setDescriptionText()
     * @param bool $photo
     * @param bool $descriptionText
     */
    public function __construct($photo = null, $descriptionText = null)
    {
        $this
            ->setPhoto($photo)
            ->setDescriptionText($descriptionText);
    }
    /**
     * Get photo value
     * @return bool
     */
    public function getPhoto()
    {
        return $this->photo;
    }
    /**
     * Set photo value
     * @param bool $photo
     * @return \StructType\CompleteInfoProduct
     */
    public function setPhoto($photo = null)
    {
        // validation for constraint: boolean
        if (!is_null($photo) && !is_bool($photo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($photo, true), gettype($photo)), __LINE__);
        }
        $this->photo = $photo;
        return $this;
    }
    /**
     * Get descriptionText value
     * @return bool
     */
    public function getDescriptionText()
    {
        return $this->descriptionText;
    }
    /**
     * Set descriptionText value
     * @param bool $descriptionText
     * @return \StructType\CompleteInfoProduct
     */
    public function setDescriptionText($descriptionText = null)
    {
        // validation for constraint: boolean
        if (!is_null($descriptionText) && !is_bool($descriptionText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($descriptionText, true), gettype($descriptionText)), __LINE__);
        }
        $this->descriptionText = $descriptionText;
        return $this;
    }
}
