<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BestOfferInSpecificRadius StructType
 * @subpackage Structs
 */
class BestOfferInSpecificRadius extends AbstractStructBase
{
    /**
     * The nbBestOfferMax
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $nbBestOfferMax;
    /**
     * The radius
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $radius;
    /**
     * The gpsLatitude
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $gpsLatitude;
    /**
     * The gpsLongitude
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $gpsLongitude;
    /**
     * Constructor method for BestOfferInSpecificRadius
     * @uses BestOfferInSpecificRadius::setNbBestOfferMax()
     * @uses BestOfferInSpecificRadius::setRadius()
     * @uses BestOfferInSpecificRadius::setGpsLatitude()
     * @uses BestOfferInSpecificRadius::setGpsLongitude()
     * @param int $nbBestOfferMax
     * @param int $radius
     * @param float $gpsLatitude
     * @param float $gpsLongitude
     */
    public function __construct($nbBestOfferMax = null, $radius = null, $gpsLatitude = null, $gpsLongitude = null)
    {
        $this
            ->setNbBestOfferMax($nbBestOfferMax)
            ->setRadius($radius)
            ->setGpsLatitude($gpsLatitude)
            ->setGpsLongitude($gpsLongitude);
    }
    /**
     * Get nbBestOfferMax value
     * @return int
     */
    public function getNbBestOfferMax()
    {
        return $this->nbBestOfferMax;
    }
    /**
     * Set nbBestOfferMax value
     * @param int $nbBestOfferMax
     * @return \StructType\BestOfferInSpecificRadius
     */
    public function setNbBestOfferMax($nbBestOfferMax = null)
    {
        // validation for constraint: int
        if (!is_null($nbBestOfferMax) && !(is_int($nbBestOfferMax) || ctype_digit($nbBestOfferMax))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($nbBestOfferMax, true), gettype($nbBestOfferMax)), __LINE__);
        }
        $this->nbBestOfferMax = $nbBestOfferMax;
        return $this;
    }
    /**
     * Get radius value
     * @return int
     */
    public function getRadius()
    {
        return $this->radius;
    }
    /**
     * Set radius value
     * @param int $radius
     * @return \StructType\BestOfferInSpecificRadius
     */
    public function setRadius($radius = null)
    {
        // validation for constraint: int
        if (!is_null($radius) && !(is_int($radius) || ctype_digit($radius))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($radius, true), gettype($radius)), __LINE__);
        }
        $this->radius = $radius;
        return $this;
    }
    /**
     * Get gpsLatitude value
     * @return float
     */
    public function getGpsLatitude()
    {
        return $this->gpsLatitude;
    }
    /**
     * Set gpsLatitude value
     * @param float $gpsLatitude
     * @return \StructType\BestOfferInSpecificRadius
     */
    public function setGpsLatitude($gpsLatitude = null)
    {
        // validation for constraint: float
        if (!is_null($gpsLatitude) && !(is_float($gpsLatitude) || is_numeric($gpsLatitude))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($gpsLatitude, true), gettype($gpsLatitude)), __LINE__);
        }
        $this->gpsLatitude = $gpsLatitude;
        return $this;
    }
    /**
     * Get gpsLongitude value
     * @return float
     */
    public function getGpsLongitude()
    {
        return $this->gpsLongitude;
    }
    /**
     * Set gpsLongitude value
     * @param float $gpsLongitude
     * @return \StructType\BestOfferInSpecificRadius
     */
    public function setGpsLongitude($gpsLongitude = null)
    {
        // validation for constraint: float
        if (!is_null($gpsLongitude) && !(is_float($gpsLongitude) || is_numeric($gpsLongitude))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($gpsLongitude, true), gettype($gpsLongitude)), __LINE__);
        }
        $this->gpsLongitude = $gpsLongitude;
        return $this;
    }
}
