<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfProductPlanning ArrayType
 * @subpackage Arrays
 */
class ArrayOfProductPlanning extends AbstractStructArrayBase
{
    /**
     * The ProductPlanning
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ProductPlanning[]
     */
    public $ProductPlanning;
    /**
     * Constructor method for ArrayOfProductPlanning
     * @uses ArrayOfProductPlanning::setProductPlanning()
     * @param \StructType\ProductPlanning[] $productPlanning
     */
    public function __construct(array $productPlanning = array())
    {
        $this
            ->setProductPlanning($productPlanning);
    }
    /**
     * Get ProductPlanning value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ProductPlanning[]|null
     */
    public function getProductPlanning()
    {
        return isset($this->ProductPlanning) ? $this->ProductPlanning : null;
    }
    /**
     * This method is responsible for validating the values passed to the setProductPlanning method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProductPlanning method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProductPlanningForArrayConstraintsFromSetProductPlanning(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfProductPlanningProductPlanningItem) {
            // validation for constraint: itemType
            if (!$arrayOfProductPlanningProductPlanningItem instanceof \StructType\ProductPlanning) {
                $invalidValues[] = is_object($arrayOfProductPlanningProductPlanningItem) ? get_class($arrayOfProductPlanningProductPlanningItem) : sprintf('%s(%s)', gettype($arrayOfProductPlanningProductPlanningItem), var_export($arrayOfProductPlanningProductPlanningItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ProductPlanning property can only contain items of type \StructType\ProductPlanning, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ProductPlanning value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ProductPlanning[] $productPlanning
     * @return \ArrayType\ArrayOfProductPlanning
     */
    public function setProductPlanning(array $productPlanning = array())
    {
        // validation for constraint: array
        if ('' !== ($productPlanningArrayErrorMessage = self::validateProductPlanningForArrayConstraintsFromSetProductPlanning($productPlanning))) {
            throw new \InvalidArgumentException($productPlanningArrayErrorMessage, __LINE__);
        }
        if (is_null($productPlanning) || (is_array($productPlanning) && empty($productPlanning))) {
            unset($this->ProductPlanning);
        } else {
            $this->ProductPlanning = $productPlanning;
        }
        return $this;
    }
    /**
     * Add item to ProductPlanning value
     * @throws \InvalidArgumentException
     * @param \StructType\ProductPlanning $item
     * @return \ArrayType\ArrayOfProductPlanning
     */
    public function addToProductPlanning(\StructType\ProductPlanning $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ProductPlanning) {
            throw new \InvalidArgumentException(sprintf('The ProductPlanning property can only contain items of type \StructType\ProductPlanning, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ProductPlanning[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ProductPlanning|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ProductPlanning|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ProductPlanning|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ProductPlanning|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ProductPlanning|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ProductPlanning
     */
    public function getAttributeName()
    {
        return 'ProductPlanning';
    }
}
