<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for establishmentInformation StructType
 * @subpackage Structs
 */
class EstablishmentInformation extends AbstractStructBase
{
    /**
     * The establishmentId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $establishmentId;
    /**
     * The anwbId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $anwbId;
    /**
     * The anwbNote
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $anwbNote;
    /**
     * The isANWB
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $isANWB;
    /**
     * The isEurotop
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $isEurotop;
    /**
     * The isPremium
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $isPremium;
    /**
     * The gpsLatitude
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $gpsLatitude;
    /**
     * The gpsLongitude
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $gpsLongitude;
    /**
     * The distanceFromRequestedPoint
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $distanceFromRequestedPoint;
    /**
     * The favorite
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $favorite;
    /**
     * The isBookable
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $isBookable;
    /**
     * The countyOsmId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $countyOsmId;
    /**
     * The countryOsmId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $countryOsmId;
    /**
     * The areaOsmId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $areaOsmId;
    /**
     * The SaleConditionsAdd
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $SaleConditionsAdd;
    /**
     * The ActiveMeanPayment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $ActiveMeanPayment;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The numberStars
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $numberStars;
    /**
     * The numberEpis
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $numberEpis;
    /**
     * The numberKeys
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $numberKeys;
    /**
     * The numberLutins
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $numberLutins;
    /**
     * The adress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $adress;
    /**
     * The postalCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $postalCode;
    /**
     * The town
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $town;
    /**
     * The codeInsee
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $codeInsee;
    /**
     * The area
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $area;
    /**
     * The country
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $country;
    /**
     * The countryCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $countryCode;
    /**
     * The admin1Code
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $admin1Code;
    /**
     * The admin2Code
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $admin2Code;
    /**
     * The phoneNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $phoneNumber;
    /**
     * The email
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $email;
    /**
     * The url
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $url;
    /**
     * The urlRedirect
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $urlRedirect;
    /**
     * The numberPitch
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $numberPitch;
    /**
     * The numberRentalAccommodation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $numberRentalAccommodation;
    /**
     * The numberRoom
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $numberRoom;
    /**
     * The syntheticPresentation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $syntheticPresentation;
    /**
     * The lastUpdate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\LastUpdate
     */
    public $lastUpdate;
    /**
     * The pictures
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString1
     */
    public $pictures;
    /**
     * The urlAvailability
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $urlAvailability;
    /**
     * The urlMoreInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $urlMoreInfo;
    /**
     * The urlOS
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $urlOS;
    /**
     * The urlPitches
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $urlPitches;
    /**
     * The urlRental
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $urlRental;
    /**
     * The urlRoom
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $urlRoom;
    /**
     * The urlDiapo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $urlDiapo;
    /**
     * The IBSSpecificInformations
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IBSSpecificInformations
     */
    public $IBSSpecificInformations;
    /**
     * The currency
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $currency;
    /**
     * The redirectionPayingGroup
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RedirectionPayingGroup
     */
    public $redirectionPayingGroup;
    /**
     * The county
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $county;
    /**
     * The touristicTown
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $touristicTown;
    /**
     * The NationalIdCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NationalIdCode;
    /**
     * Constructor method for establishmentInformation
     * @uses EstablishmentInformation::setEstablishmentId()
     * @uses EstablishmentInformation::setAnwbId()
     * @uses EstablishmentInformation::setAnwbNote()
     * @uses EstablishmentInformation::setIsANWB()
     * @uses EstablishmentInformation::setIsEurotop()
     * @uses EstablishmentInformation::setIsPremium()
     * @uses EstablishmentInformation::setGpsLatitude()
     * @uses EstablishmentInformation::setGpsLongitude()
     * @uses EstablishmentInformation::setDistanceFromRequestedPoint()
     * @uses EstablishmentInformation::setFavorite()
     * @uses EstablishmentInformation::setIsBookable()
     * @uses EstablishmentInformation::setCountyOsmId()
     * @uses EstablishmentInformation::setCountryOsmId()
     * @uses EstablishmentInformation::setAreaOsmId()
     * @uses EstablishmentInformation::setSaleConditionsAdd()
     * @uses EstablishmentInformation::setActiveMeanPayment()
     * @uses EstablishmentInformation::setName()
     * @uses EstablishmentInformation::setNumberStars()
     * @uses EstablishmentInformation::setNumberEpis()
     * @uses EstablishmentInformation::setNumberKeys()
     * @uses EstablishmentInformation::setNumberLutins()
     * @uses EstablishmentInformation::setAdress()
     * @uses EstablishmentInformation::setPostalCode()
     * @uses EstablishmentInformation::setTown()
     * @uses EstablishmentInformation::setCodeInsee()
     * @uses EstablishmentInformation::setArea()
     * @uses EstablishmentInformation::setCountry()
     * @uses EstablishmentInformation::setCountryCode()
     * @uses EstablishmentInformation::setAdmin1Code()
     * @uses EstablishmentInformation::setAdmin2Code()
     * @uses EstablishmentInformation::setPhoneNumber()
     * @uses EstablishmentInformation::setEmail()
     * @uses EstablishmentInformation::setUrl()
     * @uses EstablishmentInformation::setUrlRedirect()
     * @uses EstablishmentInformation::setNumberPitch()
     * @uses EstablishmentInformation::setNumberRentalAccommodation()
     * @uses EstablishmentInformation::setNumberRoom()
     * @uses EstablishmentInformation::setSyntheticPresentation()
     * @uses EstablishmentInformation::setLastUpdate()
     * @uses EstablishmentInformation::setPictures()
     * @uses EstablishmentInformation::setUrlAvailability()
     * @uses EstablishmentInformation::setUrlMoreInfo()
     * @uses EstablishmentInformation::setUrlOS()
     * @uses EstablishmentInformation::setUrlPitches()
     * @uses EstablishmentInformation::setUrlRental()
     * @uses EstablishmentInformation::setUrlRoom()
     * @uses EstablishmentInformation::setUrlDiapo()
     * @uses EstablishmentInformation::setIBSSpecificInformations()
     * @uses EstablishmentInformation::setCurrency()
     * @uses EstablishmentInformation::setRedirectionPayingGroup()
     * @uses EstablishmentInformation::setCounty()
     * @uses EstablishmentInformation::setTouristicTown()
     * @uses EstablishmentInformation::setNationalIdCode()
     * @param int $establishmentId
     * @param int $anwbId
     * @param float $anwbNote
     * @param bool $isANWB
     * @param bool $isEurotop
     * @param bool $isPremium
     * @param float $gpsLatitude
     * @param float $gpsLongitude
     * @param float $distanceFromRequestedPoint
     * @param bool $favorite
     * @param bool $isBookable
     * @param int $countyOsmId
     * @param int $countryOsmId
     * @param int $areaOsmId
     * @param bool $saleConditionsAdd
     * @param bool $activeMeanPayment
     * @param string $name
     * @param string $numberStars
     * @param string $numberEpis
     * @param string $numberKeys
     * @param string $numberLutins
     * @param string $adress
     * @param string $postalCode
     * @param string $town
     * @param string $codeInsee
     * @param string $area
     * @param string $country
     * @param string $countryCode
     * @param string $admin1Code
     * @param string $admin2Code
     * @param string $phoneNumber
     * @param string $email
     * @param string $url
     * @param string $urlRedirect
     * @param string $numberPitch
     * @param string $numberRentalAccommodation
     * @param string $numberRoom
     * @param string $syntheticPresentation
     * @param \StructType\LastUpdate $lastUpdate
     * @param \ArrayType\ArrayOfString1 $pictures
     * @param string $urlAvailability
     * @param string $urlMoreInfo
     * @param string $urlOS
     * @param string $urlPitches
     * @param string $urlRental
     * @param string $urlRoom
     * @param string $urlDiapo
     * @param \StructType\IBSSpecificInformations $iBSSpecificInformations
     * @param string $currency
     * @param \StructType\RedirectionPayingGroup $redirectionPayingGroup
     * @param string $county
     * @param string $touristicTown
     * @param string $nationalIdCode
     */
    public function __construct($establishmentId = null, $anwbId = null, $anwbNote = null, $isANWB = null, $isEurotop = null, $isPremium = null, $gpsLatitude = null, $gpsLongitude = null, $distanceFromRequestedPoint = null, $favorite = null, $isBookable = null, $countyOsmId = null, $countryOsmId = null, $areaOsmId = null, $saleConditionsAdd = null, $activeMeanPayment = null, $name = null, $numberStars = null, $numberEpis = null, $numberKeys = null, $numberLutins = null, $adress = null, $postalCode = null, $town = null, $codeInsee = null, $area = null, $country = null, $countryCode = null, $admin1Code = null, $admin2Code = null, $phoneNumber = null, $email = null, $url = null, $urlRedirect = null, $numberPitch = null, $numberRentalAccommodation = null, $numberRoom = null, $syntheticPresentation = null, \StructType\LastUpdate $lastUpdate = null, \ArrayType\ArrayOfString1 $pictures = null, $urlAvailability = null, $urlMoreInfo = null, $urlOS = null, $urlPitches = null, $urlRental = null, $urlRoom = null, $urlDiapo = null, \StructType\IBSSpecificInformations $iBSSpecificInformations = null, $currency = null, \StructType\RedirectionPayingGroup $redirectionPayingGroup = null, $county = null, $touristicTown = null, $nationalIdCode = null)
    {
        $this
            ->setEstablishmentId($establishmentId)
            ->setAnwbId($anwbId)
            ->setAnwbNote($anwbNote)
            ->setIsANWB($isANWB)
            ->setIsEurotop($isEurotop)
            ->setIsPremium($isPremium)
            ->setGpsLatitude($gpsLatitude)
            ->setGpsLongitude($gpsLongitude)
            ->setDistanceFromRequestedPoint($distanceFromRequestedPoint)
            ->setFavorite($favorite)
            ->setIsBookable($isBookable)
            ->setCountyOsmId($countyOsmId)
            ->setCountryOsmId($countryOsmId)
            ->setAreaOsmId($areaOsmId)
            ->setSaleConditionsAdd($saleConditionsAdd)
            ->setActiveMeanPayment($activeMeanPayment)
            ->setName($name)
            ->setNumberStars($numberStars)
            ->setNumberEpis($numberEpis)
            ->setNumberKeys($numberKeys)
            ->setNumberLutins($numberLutins)
            ->setAdress($adress)
            ->setPostalCode($postalCode)
            ->setTown($town)
            ->setCodeInsee($codeInsee)
            ->setArea($area)
            ->setCountry($country)
            ->setCountryCode($countryCode)
            ->setAdmin1Code($admin1Code)
            ->setAdmin2Code($admin2Code)
            ->setPhoneNumber($phoneNumber)
            ->setEmail($email)
            ->setUrl($url)
            ->setUrlRedirect($urlRedirect)
            ->setNumberPitch($numberPitch)
            ->setNumberRentalAccommodation($numberRentalAccommodation)
            ->setNumberRoom($numberRoom)
            ->setSyntheticPresentation($syntheticPresentation)
            ->setLastUpdate($lastUpdate)
            ->setPictures($pictures)
            ->setUrlAvailability($urlAvailability)
            ->setUrlMoreInfo($urlMoreInfo)
            ->setUrlOS($urlOS)
            ->setUrlPitches($urlPitches)
            ->setUrlRental($urlRental)
            ->setUrlRoom($urlRoom)
            ->setUrlDiapo($urlDiapo)
            ->setIBSSpecificInformations($iBSSpecificInformations)
            ->setCurrency($currency)
            ->setRedirectionPayingGroup($redirectionPayingGroup)
            ->setCounty($county)
            ->setTouristicTown($touristicTown)
            ->setNationalIdCode($nationalIdCode);
    }
    /**
     * Get establishmentId value
     * @return int
     */
    public function getEstablishmentId()
    {
        return $this->establishmentId;
    }
    /**
     * Set establishmentId value
     * @param int $establishmentId
     * @return \StructType\EstablishmentInformation
     */
    public function setEstablishmentId($establishmentId = null)
    {
        // validation for constraint: int
        if (!is_null($establishmentId) && !(is_int($establishmentId) || ctype_digit($establishmentId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($establishmentId, true), gettype($establishmentId)), __LINE__);
        }
        $this->establishmentId = $establishmentId;
        return $this;
    }
    /**
     * Get anwbId value
     * @return int
     */
    public function getAnwbId()
    {
        return $this->anwbId;
    }
    /**
     * Set anwbId value
     * @param int $anwbId
     * @return \StructType\EstablishmentInformation
     */
    public function setAnwbId($anwbId = null)
    {
        // validation for constraint: int
        if (!is_null($anwbId) && !(is_int($anwbId) || ctype_digit($anwbId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($anwbId, true), gettype($anwbId)), __LINE__);
        }
        $this->anwbId = $anwbId;
        return $this;
    }
    /**
     * Get anwbNote value
     * @return float
     */
    public function getAnwbNote()
    {
        return $this->anwbNote;
    }
    /**
     * Set anwbNote value
     * @param float $anwbNote
     * @return \StructType\EstablishmentInformation
     */
    public function setAnwbNote($anwbNote = null)
    {
        // validation for constraint: float
        if (!is_null($anwbNote) && !(is_float($anwbNote) || is_numeric($anwbNote))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($anwbNote, true), gettype($anwbNote)), __LINE__);
        }
        $this->anwbNote = $anwbNote;
        return $this;
    }
    /**
     * Get isANWB value
     * @return bool
     */
    public function getIsANWB()
    {
        return $this->isANWB;
    }
    /**
     * Set isANWB value
     * @param bool $isANWB
     * @return \StructType\EstablishmentInformation
     */
    public function setIsANWB($isANWB = null)
    {
        // validation for constraint: boolean
        if (!is_null($isANWB) && !is_bool($isANWB)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isANWB, true), gettype($isANWB)), __LINE__);
        }
        $this->isANWB = $isANWB;
        return $this;
    }
    /**
     * Get isEurotop value
     * @return bool
     */
    public function getIsEurotop()
    {
        return $this->isEurotop;
    }
    /**
     * Set isEurotop value
     * @param bool $isEurotop
     * @return \StructType\EstablishmentInformation
     */
    public function setIsEurotop($isEurotop = null)
    {
        // validation for constraint: boolean
        if (!is_null($isEurotop) && !is_bool($isEurotop)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isEurotop, true), gettype($isEurotop)), __LINE__);
        }
        $this->isEurotop = $isEurotop;
        return $this;
    }
    /**
     * Get isPremium value
     * @return bool
     */
    public function getIsPremium()
    {
        return $this->isPremium;
    }
    /**
     * Set isPremium value
     * @param bool $isPremium
     * @return \StructType\EstablishmentInformation
     */
    public function setIsPremium($isPremium = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPremium) && !is_bool($isPremium)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPremium, true), gettype($isPremium)), __LINE__);
        }
        $this->isPremium = $isPremium;
        return $this;
    }
    /**
     * Get gpsLatitude value
     * @return float
     */
    public function getGpsLatitude()
    {
        return $this->gpsLatitude;
    }
    /**
     * Set gpsLatitude value
     * @param float $gpsLatitude
     * @return \StructType\EstablishmentInformation
     */
    public function setGpsLatitude($gpsLatitude = null)
    {
        // validation for constraint: float
        if (!is_null($gpsLatitude) && !(is_float($gpsLatitude) || is_numeric($gpsLatitude))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($gpsLatitude, true), gettype($gpsLatitude)), __LINE__);
        }
        $this->gpsLatitude = $gpsLatitude;
        return $this;
    }
    /**
     * Get gpsLongitude value
     * @return float
     */
    public function getGpsLongitude()
    {
        return $this->gpsLongitude;
    }
    /**
     * Set gpsLongitude value
     * @param float $gpsLongitude
     * @return \StructType\EstablishmentInformation
     */
    public function setGpsLongitude($gpsLongitude = null)
    {
        // validation for constraint: float
        if (!is_null($gpsLongitude) && !(is_float($gpsLongitude) || is_numeric($gpsLongitude))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($gpsLongitude, true), gettype($gpsLongitude)), __LINE__);
        }
        $this->gpsLongitude = $gpsLongitude;
        return $this;
    }
    /**
     * Get distanceFromRequestedPoint value
     * @return float
     */
    public function getDistanceFromRequestedPoint()
    {
        return $this->distanceFromRequestedPoint;
    }
    /**
     * Set distanceFromRequestedPoint value
     * @param float $distanceFromRequestedPoint
     * @return \StructType\EstablishmentInformation
     */
    public function setDistanceFromRequestedPoint($distanceFromRequestedPoint = null)
    {
        // validation for constraint: float
        if (!is_null($distanceFromRequestedPoint) && !(is_float($distanceFromRequestedPoint) || is_numeric($distanceFromRequestedPoint))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($distanceFromRequestedPoint, true), gettype($distanceFromRequestedPoint)), __LINE__);
        }
        $this->distanceFromRequestedPoint = $distanceFromRequestedPoint;
        return $this;
    }
    /**
     * Get favorite value
     * @return bool
     */
    public function getFavorite()
    {
        return $this->favorite;
    }
    /**
     * Set favorite value
     * @param bool $favorite
     * @return \StructType\EstablishmentInformation
     */
    public function setFavorite($favorite = null)
    {
        // validation for constraint: boolean
        if (!is_null($favorite) && !is_bool($favorite)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($favorite, true), gettype($favorite)), __LINE__);
        }
        $this->favorite = $favorite;
        return $this;
    }
    /**
     * Get isBookable value
     * @return bool
     */
    public function getIsBookable()
    {
        return $this->isBookable;
    }
    /**
     * Set isBookable value
     * @param bool $isBookable
     * @return \StructType\EstablishmentInformation
     */
    public function setIsBookable($isBookable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isBookable) && !is_bool($isBookable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isBookable, true), gettype($isBookable)), __LINE__);
        }
        $this->isBookable = $isBookable;
        return $this;
    }
    /**
     * Get countyOsmId value
     * @return int
     */
    public function getCountyOsmId()
    {
        return $this->countyOsmId;
    }
    /**
     * Set countyOsmId value
     * @param int $countyOsmId
     * @return \StructType\EstablishmentInformation
     */
    public function setCountyOsmId($countyOsmId = null)
    {
        // validation for constraint: int
        if (!is_null($countyOsmId) && !(is_int($countyOsmId) || ctype_digit($countyOsmId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($countyOsmId, true), gettype($countyOsmId)), __LINE__);
        }
        $this->countyOsmId = $countyOsmId;
        return $this;
    }
    /**
     * Get countryOsmId value
     * @return int
     */
    public function getCountryOsmId()
    {
        return $this->countryOsmId;
    }
    /**
     * Set countryOsmId value
     * @param int $countryOsmId
     * @return \StructType\EstablishmentInformation
     */
    public function setCountryOsmId($countryOsmId = null)
    {
        // validation for constraint: int
        if (!is_null($countryOsmId) && !(is_int($countryOsmId) || ctype_digit($countryOsmId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($countryOsmId, true), gettype($countryOsmId)), __LINE__);
        }
        $this->countryOsmId = $countryOsmId;
        return $this;
    }
    /**
     * Get areaOsmId value
     * @return int
     */
    public function getAreaOsmId()
    {
        return $this->areaOsmId;
    }
    /**
     * Set areaOsmId value
     * @param int $areaOsmId
     * @return \StructType\EstablishmentInformation
     */
    public function setAreaOsmId($areaOsmId = null)
    {
        // validation for constraint: int
        if (!is_null($areaOsmId) && !(is_int($areaOsmId) || ctype_digit($areaOsmId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($areaOsmId, true), gettype($areaOsmId)), __LINE__);
        }
        $this->areaOsmId = $areaOsmId;
        return $this;
    }
    /**
     * Get SaleConditionsAdd value
     * @return bool
     */
    public function getSaleConditionsAdd()
    {
        return $this->SaleConditionsAdd;
    }
    /**
     * Set SaleConditionsAdd value
     * @param bool $saleConditionsAdd
     * @return \StructType\EstablishmentInformation
     */
    public function setSaleConditionsAdd($saleConditionsAdd = null)
    {
        // validation for constraint: boolean
        if (!is_null($saleConditionsAdd) && !is_bool($saleConditionsAdd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($saleConditionsAdd, true), gettype($saleConditionsAdd)), __LINE__);
        }
        $this->SaleConditionsAdd = $saleConditionsAdd;
        return $this;
    }
    /**
     * Get ActiveMeanPayment value
     * @return bool
     */
    public function getActiveMeanPayment()
    {
        return $this->ActiveMeanPayment;
    }
    /**
     * Set ActiveMeanPayment value
     * @param bool $activeMeanPayment
     * @return \StructType\EstablishmentInformation
     */
    public function setActiveMeanPayment($activeMeanPayment = null)
    {
        // validation for constraint: boolean
        if (!is_null($activeMeanPayment) && !is_bool($activeMeanPayment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($activeMeanPayment, true), gettype($activeMeanPayment)), __LINE__);
        }
        $this->ActiveMeanPayment = $activeMeanPayment;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\EstablishmentInformation
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get numberStars value
     * @return string|null
     */
    public function getNumberStars()
    {
        return $this->numberStars;
    }
    /**
     * Set numberStars value
     * @param string $numberStars
     * @return \StructType\EstablishmentInformation
     */
    public function setNumberStars($numberStars = null)
    {
        // validation for constraint: string
        if (!is_null($numberStars) && !is_string($numberStars)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numberStars, true), gettype($numberStars)), __LINE__);
        }
        $this->numberStars = $numberStars;
        return $this;
    }
    /**
     * Get numberEpis value
     * @return string|null
     */
    public function getNumberEpis()
    {
        return $this->numberEpis;
    }
    /**
     * Set numberEpis value
     * @param string $numberEpis
     * @return \StructType\EstablishmentInformation
     */
    public function setNumberEpis($numberEpis = null)
    {
        // validation for constraint: string
        if (!is_null($numberEpis) && !is_string($numberEpis)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numberEpis, true), gettype($numberEpis)), __LINE__);
        }
        $this->numberEpis = $numberEpis;
        return $this;
    }
    /**
     * Get numberKeys value
     * @return string|null
     */
    public function getNumberKeys()
    {
        return $this->numberKeys;
    }
    /**
     * Set numberKeys value
     * @param string $numberKeys
     * @return \StructType\EstablishmentInformation
     */
    public function setNumberKeys($numberKeys = null)
    {
        // validation for constraint: string
        if (!is_null($numberKeys) && !is_string($numberKeys)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numberKeys, true), gettype($numberKeys)), __LINE__);
        }
        $this->numberKeys = $numberKeys;
        return $this;
    }
    /**
     * Get numberLutins value
     * @return string|null
     */
    public function getNumberLutins()
    {
        return $this->numberLutins;
    }
    /**
     * Set numberLutins value
     * @param string $numberLutins
     * @return \StructType\EstablishmentInformation
     */
    public function setNumberLutins($numberLutins = null)
    {
        // validation for constraint: string
        if (!is_null($numberLutins) && !is_string($numberLutins)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numberLutins, true), gettype($numberLutins)), __LINE__);
        }
        $this->numberLutins = $numberLutins;
        return $this;
    }
    /**
     * Get adress value
     * @return string|null
     */
    public function getAdress()
    {
        return $this->adress;
    }
    /**
     * Set adress value
     * @param string $adress
     * @return \StructType\EstablishmentInformation
     */
    public function setAdress($adress = null)
    {
        // validation for constraint: string
        if (!is_null($adress) && !is_string($adress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adress, true), gettype($adress)), __LINE__);
        }
        $this->adress = $adress;
        return $this;
    }
    /**
     * Get postalCode value
     * @return string|null
     */
    public function getPostalCode()
    {
        return $this->postalCode;
    }
    /**
     * Set postalCode value
     * @param string $postalCode
     * @return \StructType\EstablishmentInformation
     */
    public function setPostalCode($postalCode = null)
    {
        // validation for constraint: string
        if (!is_null($postalCode) && !is_string($postalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postalCode, true), gettype($postalCode)), __LINE__);
        }
        $this->postalCode = $postalCode;
        return $this;
    }
    /**
     * Get town value
     * @return string|null
     */
    public function getTown()
    {
        return $this->town;
    }
    /**
     * Set town value
     * @param string $town
     * @return \StructType\EstablishmentInformation
     */
    public function setTown($town = null)
    {
        // validation for constraint: string
        if (!is_null($town) && !is_string($town)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($town, true), gettype($town)), __LINE__);
        }
        $this->town = $town;
        return $this;
    }
    /**
     * Get codeInsee value
     * @return string|null
     */
    public function getCodeInsee()
    {
        return $this->codeInsee;
    }
    /**
     * Set codeInsee value
     * @param string $codeInsee
     * @return \StructType\EstablishmentInformation
     */
    public function setCodeInsee($codeInsee = null)
    {
        // validation for constraint: string
        if (!is_null($codeInsee) && !is_string($codeInsee)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codeInsee, true), gettype($codeInsee)), __LINE__);
        }
        $this->codeInsee = $codeInsee;
        return $this;
    }
    /**
     * Get area value
     * @return string|null
     */
    public function getArea()
    {
        return $this->area;
    }
    /**
     * Set area value
     * @param string $area
     * @return \StructType\EstablishmentInformation
     */
    public function setArea($area = null)
    {
        // validation for constraint: string
        if (!is_null($area) && !is_string($area)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($area, true), gettype($area)), __LINE__);
        }
        $this->area = $area;
        return $this;
    }
    /**
     * Get country value
     * @return string|null
     */
    public function getCountry()
    {
        return $this->country;
    }
    /**
     * Set country value
     * @param string $country
     * @return \StructType\EstablishmentInformation
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($country, true), gettype($country)), __LINE__);
        }
        $this->country = $country;
        return $this;
    }
    /**
     * Get countryCode value
     * @return string|null
     */
    public function getCountryCode()
    {
        return $this->countryCode;
    }
    /**
     * Set countryCode value
     * @param string $countryCode
     * @return \StructType\EstablishmentInformation
     */
    public function setCountryCode($countryCode = null)
    {
        // validation for constraint: string
        if (!is_null($countryCode) && !is_string($countryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryCode, true), gettype($countryCode)), __LINE__);
        }
        $this->countryCode = $countryCode;
        return $this;
    }
    /**
     * Get admin1Code value
     * @return string|null
     */
    public function getAdmin1Code()
    {
        return $this->admin1Code;
    }
    /**
     * Set admin1Code value
     * @param string $admin1Code
     * @return \StructType\EstablishmentInformation
     */
    public function setAdmin1Code($admin1Code = null)
    {
        // validation for constraint: string
        if (!is_null($admin1Code) && !is_string($admin1Code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($admin1Code, true), gettype($admin1Code)), __LINE__);
        }
        $this->admin1Code = $admin1Code;
        return $this;
    }
    /**
     * Get admin2Code value
     * @return string|null
     */
    public function getAdmin2Code()
    {
        return $this->admin2Code;
    }
    /**
     * Set admin2Code value
     * @param string $admin2Code
     * @return \StructType\EstablishmentInformation
     */
    public function setAdmin2Code($admin2Code = null)
    {
        // validation for constraint: string
        if (!is_null($admin2Code) && !is_string($admin2Code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($admin2Code, true), gettype($admin2Code)), __LINE__);
        }
        $this->admin2Code = $admin2Code;
        return $this;
    }
    /**
     * Get phoneNumber value
     * @return string|null
     */
    public function getPhoneNumber()
    {
        return $this->phoneNumber;
    }
    /**
     * Set phoneNumber value
     * @param string $phoneNumber
     * @return \StructType\EstablishmentInformation
     */
    public function setPhoneNumber($phoneNumber = null)
    {
        // validation for constraint: string
        if (!is_null($phoneNumber) && !is_string($phoneNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phoneNumber, true), gettype($phoneNumber)), __LINE__);
        }
        $this->phoneNumber = $phoneNumber;
        return $this;
    }
    /**
     * Get email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * Set email value
     * @param string $email
     * @return \StructType\EstablishmentInformation
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        $this->email = $email;
        return $this;
    }
    /**
     * Get url value
     * @return string|null
     */
    public function getUrl()
    {
        return $this->url;
    }
    /**
     * Set url value
     * @param string $url
     * @return \StructType\EstablishmentInformation
     */
    public function setUrl($url = null)
    {
        // validation for constraint: string
        if (!is_null($url) && !is_string($url)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($url, true), gettype($url)), __LINE__);
        }
        $this->url = $url;
        return $this;
    }
    /**
     * Get urlRedirect value
     * @return string|null
     */
    public function getUrlRedirect()
    {
        return $this->urlRedirect;
    }
    /**
     * Set urlRedirect value
     * @param string $urlRedirect
     * @return \StructType\EstablishmentInformation
     */
    public function setUrlRedirect($urlRedirect = null)
    {
        // validation for constraint: string
        if (!is_null($urlRedirect) && !is_string($urlRedirect)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($urlRedirect, true), gettype($urlRedirect)), __LINE__);
        }
        $this->urlRedirect = $urlRedirect;
        return $this;
    }
    /**
     * Get numberPitch value
     * @return string|null
     */
    public function getNumberPitch()
    {
        return $this->numberPitch;
    }
    /**
     * Set numberPitch value
     * @param string $numberPitch
     * @return \StructType\EstablishmentInformation
     */
    public function setNumberPitch($numberPitch = null)
    {
        // validation for constraint: string
        if (!is_null($numberPitch) && !is_string($numberPitch)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numberPitch, true), gettype($numberPitch)), __LINE__);
        }
        $this->numberPitch = $numberPitch;
        return $this;
    }
    /**
     * Get numberRentalAccommodation value
     * @return string|null
     */
    public function getNumberRentalAccommodation()
    {
        return $this->numberRentalAccommodation;
    }
    /**
     * Set numberRentalAccommodation value
     * @param string $numberRentalAccommodation
     * @return \StructType\EstablishmentInformation
     */
    public function setNumberRentalAccommodation($numberRentalAccommodation = null)
    {
        // validation for constraint: string
        if (!is_null($numberRentalAccommodation) && !is_string($numberRentalAccommodation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numberRentalAccommodation, true), gettype($numberRentalAccommodation)), __LINE__);
        }
        $this->numberRentalAccommodation = $numberRentalAccommodation;
        return $this;
    }
    /**
     * Get numberRoom value
     * @return string|null
     */
    public function getNumberRoom()
    {
        return $this->numberRoom;
    }
    /**
     * Set numberRoom value
     * @param string $numberRoom
     * @return \StructType\EstablishmentInformation
     */
    public function setNumberRoom($numberRoom = null)
    {
        // validation for constraint: string
        if (!is_null($numberRoom) && !is_string($numberRoom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numberRoom, true), gettype($numberRoom)), __LINE__);
        }
        $this->numberRoom = $numberRoom;
        return $this;
    }
    /**
     * Get syntheticPresentation value
     * @return string|null
     */
    public function getSyntheticPresentation()
    {
        return $this->syntheticPresentation;
    }
    /**
     * Set syntheticPresentation value
     * @param string $syntheticPresentation
     * @return \StructType\EstablishmentInformation
     */
    public function setSyntheticPresentation($syntheticPresentation = null)
    {
        // validation for constraint: string
        if (!is_null($syntheticPresentation) && !is_string($syntheticPresentation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($syntheticPresentation, true), gettype($syntheticPresentation)), __LINE__);
        }
        $this->syntheticPresentation = $syntheticPresentation;
        return $this;
    }
    /**
     * Get lastUpdate value
     * @return \StructType\LastUpdate|null
     */
    public function getLastUpdate()
    {
        return $this->lastUpdate;
    }
    /**
     * Set lastUpdate value
     * @param \StructType\LastUpdate $lastUpdate
     * @return \StructType\EstablishmentInformation
     */
    public function setLastUpdate(\StructType\LastUpdate $lastUpdate = null)
    {
        $this->lastUpdate = $lastUpdate;
        return $this;
    }
    /**
     * Get pictures value
     * @return \ArrayType\ArrayOfString1|null
     */
    public function getPictures()
    {
        return $this->pictures;
    }
    /**
     * Set pictures value
     * @param \ArrayType\ArrayOfString1 $pictures
     * @return \StructType\EstablishmentInformation
     */
    public function setPictures(\ArrayType\ArrayOfString1 $pictures = null)
    {
        $this->pictures = $pictures;
        return $this;
    }
    /**
     * Get urlAvailability value
     * @return string|null
     */
    public function getUrlAvailability()
    {
        return $this->urlAvailability;
    }
    /**
     * Set urlAvailability value
     * @param string $urlAvailability
     * @return \StructType\EstablishmentInformation
     */
    public function setUrlAvailability($urlAvailability = null)
    {
        // validation for constraint: string
        if (!is_null($urlAvailability) && !is_string($urlAvailability)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($urlAvailability, true), gettype($urlAvailability)), __LINE__);
        }
        $this->urlAvailability = $urlAvailability;
        return $this;
    }
    /**
     * Get urlMoreInfo value
     * @return string|null
     */
    public function getUrlMoreInfo()
    {
        return $this->urlMoreInfo;
    }
    /**
     * Set urlMoreInfo value
     * @param string $urlMoreInfo
     * @return \StructType\EstablishmentInformation
     */
    public function setUrlMoreInfo($urlMoreInfo = null)
    {
        // validation for constraint: string
        if (!is_null($urlMoreInfo) && !is_string($urlMoreInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($urlMoreInfo, true), gettype($urlMoreInfo)), __LINE__);
        }
        $this->urlMoreInfo = $urlMoreInfo;
        return $this;
    }
    /**
     * Get urlOS value
     * @return string|null
     */
    public function getUrlOS()
    {
        return $this->urlOS;
    }
    /**
     * Set urlOS value
     * @param string $urlOS
     * @return \StructType\EstablishmentInformation
     */
    public function setUrlOS($urlOS = null)
    {
        // validation for constraint: string
        if (!is_null($urlOS) && !is_string($urlOS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($urlOS, true), gettype($urlOS)), __LINE__);
        }
        $this->urlOS = $urlOS;
        return $this;
    }
    /**
     * Get urlPitches value
     * @return string|null
     */
    public function getUrlPitches()
    {
        return $this->urlPitches;
    }
    /**
     * Set urlPitches value
     * @param string $urlPitches
     * @return \StructType\EstablishmentInformation
     */
    public function setUrlPitches($urlPitches = null)
    {
        // validation for constraint: string
        if (!is_null($urlPitches) && !is_string($urlPitches)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($urlPitches, true), gettype($urlPitches)), __LINE__);
        }
        $this->urlPitches = $urlPitches;
        return $this;
    }
    /**
     * Get urlRental value
     * @return string|null
     */
    public function getUrlRental()
    {
        return $this->urlRental;
    }
    /**
     * Set urlRental value
     * @param string $urlRental
     * @return \StructType\EstablishmentInformation
     */
    public function setUrlRental($urlRental = null)
    {
        // validation for constraint: string
        if (!is_null($urlRental) && !is_string($urlRental)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($urlRental, true), gettype($urlRental)), __LINE__);
        }
        $this->urlRental = $urlRental;
        return $this;
    }
    /**
     * Get urlRoom value
     * @return string|null
     */
    public function getUrlRoom()
    {
        return $this->urlRoom;
    }
    /**
     * Set urlRoom value
     * @param string $urlRoom
     * @return \StructType\EstablishmentInformation
     */
    public function setUrlRoom($urlRoom = null)
    {
        // validation for constraint: string
        if (!is_null($urlRoom) && !is_string($urlRoom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($urlRoom, true), gettype($urlRoom)), __LINE__);
        }
        $this->urlRoom = $urlRoom;
        return $this;
    }
    /**
     * Get urlDiapo value
     * @return string|null
     */
    public function getUrlDiapo()
    {
        return $this->urlDiapo;
    }
    /**
     * Set urlDiapo value
     * @param string $urlDiapo
     * @return \StructType\EstablishmentInformation
     */
    public function setUrlDiapo($urlDiapo = null)
    {
        // validation for constraint: string
        if (!is_null($urlDiapo) && !is_string($urlDiapo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($urlDiapo, true), gettype($urlDiapo)), __LINE__);
        }
        $this->urlDiapo = $urlDiapo;
        return $this;
    }
    /**
     * Get IBSSpecificInformations value
     * @return \StructType\IBSSpecificInformations|null
     */
    public function getIBSSpecificInformations()
    {
        return $this->IBSSpecificInformations;
    }
    /**
     * Set IBSSpecificInformations value
     * @param \StructType\IBSSpecificInformations $iBSSpecificInformations
     * @return \StructType\EstablishmentInformation
     */
    public function setIBSSpecificInformations(\StructType\IBSSpecificInformations $iBSSpecificInformations = null)
    {
        $this->IBSSpecificInformations = $iBSSpecificInformations;
        return $this;
    }
    /**
     * Get currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @param string $currency
     * @return \StructType\EstablishmentInformation
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        $this->currency = $currency;
        return $this;
    }
    /**
     * Get redirectionPayingGroup value
     * @return \StructType\RedirectionPayingGroup|null
     */
    public function getRedirectionPayingGroup()
    {
        return $this->redirectionPayingGroup;
    }
    /**
     * Set redirectionPayingGroup value
     * @param \StructType\RedirectionPayingGroup $redirectionPayingGroup
     * @return \StructType\EstablishmentInformation
     */
    public function setRedirectionPayingGroup(\StructType\RedirectionPayingGroup $redirectionPayingGroup = null)
    {
        $this->redirectionPayingGroup = $redirectionPayingGroup;
        return $this;
    }
    /**
     * Get county value
     * @return string|null
     */
    public function getCounty()
    {
        return $this->county;
    }
    /**
     * Set county value
     * @param string $county
     * @return \StructType\EstablishmentInformation
     */
    public function setCounty($county = null)
    {
        // validation for constraint: string
        if (!is_null($county) && !is_string($county)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($county, true), gettype($county)), __LINE__);
        }
        $this->county = $county;
        return $this;
    }
    /**
     * Get touristicTown value
     * @return string|null
     */
    public function getTouristicTown()
    {
        return $this->touristicTown;
    }
    /**
     * Set touristicTown value
     * @param string $touristicTown
     * @return \StructType\EstablishmentInformation
     */
    public function setTouristicTown($touristicTown = null)
    {
        // validation for constraint: string
        if (!is_null($touristicTown) && !is_string($touristicTown)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($touristicTown, true), gettype($touristicTown)), __LINE__);
        }
        $this->touristicTown = $touristicTown;
        return $this;
    }
    /**
     * Get NationalIdCode value
     * @return string|null
     */
    public function getNationalIdCode()
    {
        return $this->NationalIdCode;
    }
    /**
     * Set NationalIdCode value
     * @param string $nationalIdCode
     * @return \StructType\EstablishmentInformation
     */
    public function setNationalIdCode($nationalIdCode = null)
    {
        // validation for constraint: string
        if (!is_null($nationalIdCode) && !is_string($nationalIdCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nationalIdCode, true), gettype($nationalIdCode)), __LINE__);
        }
        $this->NationalIdCode = $nationalIdCode;
        return $this;
    }
}
