<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeadlineByProductType StructType
 * @subpackage Structs
 */
class DeadlineByProductType extends AbstractStructBase
{
    /**
     * The ProductType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ProductType;
    /**
     * The NbDays
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $NbDays;
    /**
     * The LimitHour
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $LimitHour;
    /**
     * Constructor method for DeadlineByProductType
     * @uses DeadlineByProductType::setProductType()
     * @uses DeadlineByProductType::setNbDays()
     * @uses DeadlineByProductType::setLimitHour()
     * @param string $productType
     * @param int $nbDays
     * @param int $limitHour
     */
    public function __construct($productType = null, $nbDays = null, $limitHour = null)
    {
        $this
            ->setProductType($productType)
            ->setNbDays($nbDays)
            ->setLimitHour($limitHour);
    }
    /**
     * Get ProductType value
     * @return string
     */
    public function getProductType()
    {
        return $this->ProductType;
    }
    /**
     * Set ProductType value
     * @uses \EnumType\ProductType::valueIsValid()
     * @uses \EnumType\ProductType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $productType
     * @return \StructType\DeadlineByProductType
     */
    public function setProductType($productType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ProductType::valueIsValid($productType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ProductType', is_array($productType) ? implode(', ', $productType) : var_export($productType, true), implode(', ', \EnumType\ProductType::getValidValues())), __LINE__);
        }
        $this->ProductType = $productType;
        return $this;
    }
    /**
     * Get NbDays value
     * @return int
     */
    public function getNbDays()
    {
        return $this->NbDays;
    }
    /**
     * Set NbDays value
     * @param int $nbDays
     * @return \StructType\DeadlineByProductType
     */
    public function setNbDays($nbDays = null)
    {
        // validation for constraint: int
        if (!is_null($nbDays) && !(is_int($nbDays) || ctype_digit($nbDays))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($nbDays, true), gettype($nbDays)), __LINE__);
        }
        $this->NbDays = $nbDays;
        return $this;
    }
    /**
     * Get LimitHour value
     * @return int
     */
    public function getLimitHour()
    {
        return $this->LimitHour;
    }
    /**
     * Set LimitHour value
     * @param int $limitHour
     * @return \StructType\DeadlineByProductType
     */
    public function setLimitHour($limitHour = null)
    {
        // validation for constraint: int
        if (!is_null($limitHour) && !(is_int($limitHour) || ctype_digit($limitHour))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($limitHour, true), gettype($limitHour)), __LINE__);
        }
        $this->LimitHour = $limitHour;
        return $this;
    }
}
