<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for productPeriod StructType
 * @subpackage Structs
 */
class ProductPeriod extends AbstractStructBase
{
    /**
     * The startDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $startDate;
    /**
     * The endDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $endDate;
    /**
     * The tariff
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $tariff;
    /**
     * The weekendPrice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $weekendPrice;
    /**
     * The firstNightPrice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $firstNightPrice;
    /**
     * The conditions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Conditions
     */
    public $conditions;
    /**
     * The currency
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $currency;
    /**
     * The options
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfOption
     */
    public $options;
    /**
     * The weekendPrices
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfProductWeekEndPrice
     */
    public $weekendPrices;
    /**
     * The firstNightPrices
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfProductFirstNightPrice
     */
    public $firstNightPrices;
    /**
     * The shortStayPrices
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfProductShortStayPrice
     */
    public $shortStayPrices;
    /**
     * Constructor method for productPeriod
     * @uses ProductPeriod::setStartDate()
     * @uses ProductPeriod::setEndDate()
     * @uses ProductPeriod::setTariff()
     * @uses ProductPeriod::setWeekendPrice()
     * @uses ProductPeriod::setFirstNightPrice()
     * @uses ProductPeriod::setConditions()
     * @uses ProductPeriod::setCurrency()
     * @uses ProductPeriod::setOptions()
     * @uses ProductPeriod::setWeekendPrices()
     * @uses ProductPeriod::setFirstNightPrices()
     * @uses ProductPeriod::setShortStayPrices()
     * @param string $startDate
     * @param string $endDate
     * @param float $tariff
     * @param float $weekendPrice
     * @param float $firstNightPrice
     * @param \StructType\Conditions $conditions
     * @param string $currency
     * @param \ArrayType\ArrayOfOption $options
     * @param \ArrayType\ArrayOfProductWeekEndPrice $weekendPrices
     * @param \ArrayType\ArrayOfProductFirstNightPrice $firstNightPrices
     * @param \ArrayType\ArrayOfProductShortStayPrice $shortStayPrices
     */
    public function __construct($startDate = null, $endDate = null, $tariff = null, $weekendPrice = null, $firstNightPrice = null, \StructType\Conditions $conditions = null, $currency = null, \ArrayType\ArrayOfOption $options = null, \ArrayType\ArrayOfProductWeekEndPrice $weekendPrices = null, \ArrayType\ArrayOfProductFirstNightPrice $firstNightPrices = null, \ArrayType\ArrayOfProductShortStayPrice $shortStayPrices = null)
    {
        $this
            ->setStartDate($startDate)
            ->setEndDate($endDate)
            ->setTariff($tariff)
            ->setWeekendPrice($weekendPrice)
            ->setFirstNightPrice($firstNightPrice)
            ->setConditions($conditions)
            ->setCurrency($currency)
            ->setOptions($options)
            ->setWeekendPrices($weekendPrices)
            ->setFirstNightPrices($firstNightPrices)
            ->setShortStayPrices($shortStayPrices);
    }
    /**
     * Get startDate value
     * @return string
     */
    public function getStartDate()
    {
        return $this->startDate;
    }
    /**
     * Set startDate value
     * @param string $startDate
     * @return \StructType\ProductPeriod
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDate, true), gettype($startDate)), __LINE__);
        }
        $this->startDate = $startDate;
        return $this;
    }
    /**
     * Get endDate value
     * @return string
     */
    public function getEndDate()
    {
        return $this->endDate;
    }
    /**
     * Set endDate value
     * @param string $endDate
     * @return \StructType\ProductPeriod
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDate, true), gettype($endDate)), __LINE__);
        }
        $this->endDate = $endDate;
        return $this;
    }
    /**
     * Get tariff value
     * @return float
     */
    public function getTariff()
    {
        return $this->tariff;
    }
    /**
     * Set tariff value
     * @param float $tariff
     * @return \StructType\ProductPeriod
     */
    public function setTariff($tariff = null)
    {
        // validation for constraint: float
        if (!is_null($tariff) && !(is_float($tariff) || is_numeric($tariff))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($tariff, true), gettype($tariff)), __LINE__);
        }
        $this->tariff = $tariff;
        return $this;
    }
    /**
     * Get weekendPrice value
     * @return float
     */
    public function getWeekendPrice()
    {
        return $this->weekendPrice;
    }
    /**
     * Set weekendPrice value
     * @param float $weekendPrice
     * @return \StructType\ProductPeriod
     */
    public function setWeekendPrice($weekendPrice = null)
    {
        // validation for constraint: float
        if (!is_null($weekendPrice) && !(is_float($weekendPrice) || is_numeric($weekendPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($weekendPrice, true), gettype($weekendPrice)), __LINE__);
        }
        $this->weekendPrice = $weekendPrice;
        return $this;
    }
    /**
     * Get firstNightPrice value
     * @return float
     */
    public function getFirstNightPrice()
    {
        return $this->firstNightPrice;
    }
    /**
     * Set firstNightPrice value
     * @param float $firstNightPrice
     * @return \StructType\ProductPeriod
     */
    public function setFirstNightPrice($firstNightPrice = null)
    {
        // validation for constraint: float
        if (!is_null($firstNightPrice) && !(is_float($firstNightPrice) || is_numeric($firstNightPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($firstNightPrice, true), gettype($firstNightPrice)), __LINE__);
        }
        $this->firstNightPrice = $firstNightPrice;
        return $this;
    }
    /**
     * Get conditions value
     * @return \StructType\Conditions
     */
    public function getConditions()
    {
        return $this->conditions;
    }
    /**
     * Set conditions value
     * @param \StructType\Conditions $conditions
     * @return \StructType\ProductPeriod
     */
    public function setConditions(\StructType\Conditions $conditions = null)
    {
        $this->conditions = $conditions;
        return $this;
    }
    /**
     * Get currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @param string $currency
     * @return \StructType\ProductPeriod
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        $this->currency = $currency;
        return $this;
    }
    /**
     * Get options value
     * @return \ArrayType\ArrayOfOption|null
     */
    public function getOptions()
    {
        return $this->options;
    }
    /**
     * Set options value
     * @param \ArrayType\ArrayOfOption $options
     * @return \StructType\ProductPeriod
     */
    public function setOptions(\ArrayType\ArrayOfOption $options = null)
    {
        $this->options = $options;
        return $this;
    }
    /**
     * Get weekendPrices value
     * @return \ArrayType\ArrayOfProductWeekEndPrice|null
     */
    public function getWeekendPrices()
    {
        return $this->weekendPrices;
    }
    /**
     * Set weekendPrices value
     * @param \ArrayType\ArrayOfProductWeekEndPrice $weekendPrices
     * @return \StructType\ProductPeriod
     */
    public function setWeekendPrices(\ArrayType\ArrayOfProductWeekEndPrice $weekendPrices = null)
    {
        $this->weekendPrices = $weekendPrices;
        return $this;
    }
    /**
     * Get firstNightPrices value
     * @return \ArrayType\ArrayOfProductFirstNightPrice|null
     */
    public function getFirstNightPrices()
    {
        return $this->firstNightPrices;
    }
    /**
     * Set firstNightPrices value
     * @param \ArrayType\ArrayOfProductFirstNightPrice $firstNightPrices
     * @return \StructType\ProductPeriod
     */
    public function setFirstNightPrices(\ArrayType\ArrayOfProductFirstNightPrice $firstNightPrices = null)
    {
        $this->firstNightPrices = $firstNightPrices;
        return $this;
    }
    /**
     * Get shortStayPrices value
     * @return \ArrayType\ArrayOfProductShortStayPrice|null
     */
    public function getShortStayPrices()
    {
        return $this->shortStayPrices;
    }
    /**
     * Set shortStayPrices value
     * @param \ArrayType\ArrayOfProductShortStayPrice $shortStayPrices
     * @return \StructType\ProductPeriod
     */
    public function setShortStayPrices(\ArrayType\ArrayOfProductShortStayPrice $shortStayPrices = null)
    {
        $this->shortStayPrices = $shortStayPrices;
        return $this;
    }
}
