<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IncreasedPricesInformation StructType
 * @subpackage Structs
 */
class IncreasedPricesInformation extends AbstractStructBase
{
    /**
     * The EstablishmentId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $EstablishmentId;
    /**
     * The RatePercent
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $RatePercent;
    /**
     * The RateFix
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $RateFix;
    /**
     * The EstablishmentName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EstablishmentName;
    /**
     * Constructor method for IncreasedPricesInformation
     * @uses IncreasedPricesInformation::setEstablishmentId()
     * @uses IncreasedPricesInformation::setRatePercent()
     * @uses IncreasedPricesInformation::setRateFix()
     * @uses IncreasedPricesInformation::setEstablishmentName()
     * @param int $establishmentId
     * @param float $ratePercent
     * @param float $rateFix
     * @param string $establishmentName
     */
    public function __construct($establishmentId = null, $ratePercent = null, $rateFix = null, $establishmentName = null)
    {
        $this
            ->setEstablishmentId($establishmentId)
            ->setRatePercent($ratePercent)
            ->setRateFix($rateFix)
            ->setEstablishmentName($establishmentName);
    }
    /**
     * Get EstablishmentId value
     * @return int
     */
    public function getEstablishmentId()
    {
        return $this->EstablishmentId;
    }
    /**
     * Set EstablishmentId value
     * @param int $establishmentId
     * @return \StructType\IncreasedPricesInformation
     */
    public function setEstablishmentId($establishmentId = null)
    {
        // validation for constraint: int
        if (!is_null($establishmentId) && !(is_int($establishmentId) || ctype_digit($establishmentId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($establishmentId, true), gettype($establishmentId)), __LINE__);
        }
        $this->EstablishmentId = $establishmentId;
        return $this;
    }
    /**
     * Get RatePercent value
     * @return float
     */
    public function getRatePercent()
    {
        return $this->RatePercent;
    }
    /**
     * Set RatePercent value
     * @param float $ratePercent
     * @return \StructType\IncreasedPricesInformation
     */
    public function setRatePercent($ratePercent = null)
    {
        // validation for constraint: float
        if (!is_null($ratePercent) && !(is_float($ratePercent) || is_numeric($ratePercent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ratePercent, true), gettype($ratePercent)), __LINE__);
        }
        $this->RatePercent = $ratePercent;
        return $this;
    }
    /**
     * Get RateFix value
     * @return float
     */
    public function getRateFix()
    {
        return $this->RateFix;
    }
    /**
     * Set RateFix value
     * @param float $rateFix
     * @return \StructType\IncreasedPricesInformation
     */
    public function setRateFix($rateFix = null)
    {
        // validation for constraint: float
        if (!is_null($rateFix) && !(is_float($rateFix) || is_numeric($rateFix))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($rateFix, true), gettype($rateFix)), __LINE__);
        }
        $this->RateFix = $rateFix;
        return $this;
    }
    /**
     * Get EstablishmentName value
     * @return string|null
     */
    public function getEstablishmentName()
    {
        return $this->EstablishmentName;
    }
    /**
     * Set EstablishmentName value
     * @param string $establishmentName
     * @return \StructType\IncreasedPricesInformation
     */
    public function setEstablishmentName($establishmentName = null)
    {
        // validation for constraint: string
        if (!is_null($establishmentName) && !is_string($establishmentName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($establishmentName, true), gettype($establishmentName)), __LINE__);
        }
        $this->EstablishmentName = $establishmentName;
        return $this;
    }
}
