<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PricesInfo StructType
 * @subpackage Structs
 */
class PricesInfo extends AbstractStructBase
{
    /**
     * The NumProduct
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $NumProduct;
    /**
     * The PriceMin
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $PriceMin;
    /**
     * The PriceMax
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $PriceMax;
    /**
     * The DurationPriceMin
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $DurationPriceMin;
    /**
     * The DurationPriceMax
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $DurationPriceMax;
    /**
     * The NameProduct
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NameProduct;
    /**
     * Constructor method for PricesInfo
     * @uses PricesInfo::setNumProduct()
     * @uses PricesInfo::setPriceMin()
     * @uses PricesInfo::setPriceMax()
     * @uses PricesInfo::setDurationPriceMin()
     * @uses PricesInfo::setDurationPriceMax()
     * @uses PricesInfo::setNameProduct()
     * @param int $numProduct
     * @param float $priceMin
     * @param float $priceMax
     * @param int $durationPriceMin
     * @param int $durationPriceMax
     * @param string $nameProduct
     */
    public function __construct($numProduct = null, $priceMin = null, $priceMax = null, $durationPriceMin = null, $durationPriceMax = null, $nameProduct = null)
    {
        $this
            ->setNumProduct($numProduct)
            ->setPriceMin($priceMin)
            ->setPriceMax($priceMax)
            ->setDurationPriceMin($durationPriceMin)
            ->setDurationPriceMax($durationPriceMax)
            ->setNameProduct($nameProduct);
    }
    /**
     * Get NumProduct value
     * @return int
     */
    public function getNumProduct()
    {
        return $this->NumProduct;
    }
    /**
     * Set NumProduct value
     * @param int $numProduct
     * @return \StructType\PricesInfo
     */
    public function setNumProduct($numProduct = null)
    {
        // validation for constraint: int
        if (!is_null($numProduct) && !(is_int($numProduct) || ctype_digit($numProduct))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numProduct, true), gettype($numProduct)), __LINE__);
        }
        $this->NumProduct = $numProduct;
        return $this;
    }
    /**
     * Get PriceMin value
     * @return float
     */
    public function getPriceMin()
    {
        return $this->PriceMin;
    }
    /**
     * Set PriceMin value
     * @param float $priceMin
     * @return \StructType\PricesInfo
     */
    public function setPriceMin($priceMin = null)
    {
        // validation for constraint: float
        if (!is_null($priceMin) && !(is_float($priceMin) || is_numeric($priceMin))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($priceMin, true), gettype($priceMin)), __LINE__);
        }
        $this->PriceMin = $priceMin;
        return $this;
    }
    /**
     * Get PriceMax value
     * @return float
     */
    public function getPriceMax()
    {
        return $this->PriceMax;
    }
    /**
     * Set PriceMax value
     * @param float $priceMax
     * @return \StructType\PricesInfo
     */
    public function setPriceMax($priceMax = null)
    {
        // validation for constraint: float
        if (!is_null($priceMax) && !(is_float($priceMax) || is_numeric($priceMax))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($priceMax, true), gettype($priceMax)), __LINE__);
        }
        $this->PriceMax = $priceMax;
        return $this;
    }
    /**
     * Get DurationPriceMin value
     * @return int
     */
    public function getDurationPriceMin()
    {
        return $this->DurationPriceMin;
    }
    /**
     * Set DurationPriceMin value
     * @param int $durationPriceMin
     * @return \StructType\PricesInfo
     */
    public function setDurationPriceMin($durationPriceMin = null)
    {
        // validation for constraint: int
        if (!is_null($durationPriceMin) && !(is_int($durationPriceMin) || ctype_digit($durationPriceMin))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($durationPriceMin, true), gettype($durationPriceMin)), __LINE__);
        }
        $this->DurationPriceMin = $durationPriceMin;
        return $this;
    }
    /**
     * Get DurationPriceMax value
     * @return int
     */
    public function getDurationPriceMax()
    {
        return $this->DurationPriceMax;
    }
    /**
     * Set DurationPriceMax value
     * @param int $durationPriceMax
     * @return \StructType\PricesInfo
     */
    public function setDurationPriceMax($durationPriceMax = null)
    {
        // validation for constraint: int
        if (!is_null($durationPriceMax) && !(is_int($durationPriceMax) || ctype_digit($durationPriceMax))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($durationPriceMax, true), gettype($durationPriceMax)), __LINE__);
        }
        $this->DurationPriceMax = $durationPriceMax;
        return $this;
    }
    /**
     * Get NameProduct value
     * @return string|null
     */
    public function getNameProduct()
    {
        return $this->NameProduct;
    }
    /**
     * Set NameProduct value
     * @param string $nameProduct
     * @return \StructType\PricesInfo
     */
    public function setNameProduct($nameProduct = null)
    {
        // validation for constraint: string
        if (!is_null($nameProduct) && !is_string($nameProduct)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nameProduct, true), gettype($nameProduct)), __LINE__);
        }
        $this->NameProduct = $nameProduct;
        return $this;
    }
}
