<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Period StructType
 * @subpackage Structs
 */
class Period extends AbstractStructBase
{
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Id;
    /**
     * The BeginDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $BeginDate;
    /**
     * The EndDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $EndDate;
    /**
     * The Duration
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Duration;
    /**
     * The BeginWeekDays
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfDayOfWeek
     */
    public $BeginWeekDays;
    /**
     * The EndWeekDays
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfDayOfWeek
     */
    public $EndWeekDays;
    /**
     * The Label
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Label;
    /**
     * Constructor method for Period
     * @uses Period::setId()
     * @uses Period::setBeginDate()
     * @uses Period::setEndDate()
     * @uses Period::setDuration()
     * @uses Period::setBeginWeekDays()
     * @uses Period::setEndWeekDays()
     * @uses Period::setLabel()
     * @param int $id
     * @param string $beginDate
     * @param string $endDate
     * @param int $duration
     * @param \ArrayType\ArrayOfDayOfWeek $beginWeekDays
     * @param \ArrayType\ArrayOfDayOfWeek $endWeekDays
     * @param string $label
     */
    public function __construct($id = null, $beginDate = null, $endDate = null, $duration = null, \ArrayType\ArrayOfDayOfWeek $beginWeekDays = null, \ArrayType\ArrayOfDayOfWeek $endWeekDays = null, $label = null)
    {
        $this
            ->setId($id)
            ->setBeginDate($beginDate)
            ->setEndDate($endDate)
            ->setDuration($duration)
            ->setBeginWeekDays($beginWeekDays)
            ->setEndWeekDays($endWeekDays)
            ->setLabel($label);
    }
    /**
     * Get Id value
     * @return int
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \StructType\Period
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get BeginDate value
     * @return string
     */
    public function getBeginDate()
    {
        return $this->BeginDate;
    }
    /**
     * Set BeginDate value
     * @param string $beginDate
     * @return \StructType\Period
     */
    public function setBeginDate($beginDate = null)
    {
        // validation for constraint: string
        if (!is_null($beginDate) && !is_string($beginDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($beginDate, true), gettype($beginDate)), __LINE__);
        }
        $this->BeginDate = $beginDate;
        return $this;
    }
    /**
     * Get EndDate value
     * @return string
     */
    public function getEndDate()
    {
        return $this->EndDate;
    }
    /**
     * Set EndDate value
     * @param string $endDate
     * @return \StructType\Period
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDate, true), gettype($endDate)), __LINE__);
        }
        $this->EndDate = $endDate;
        return $this;
    }
    /**
     * Get Duration value
     * @return int
     */
    public function getDuration()
    {
        return $this->Duration;
    }
    /**
     * Set Duration value
     * @param int $duration
     * @return \StructType\Period
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: int
        if (!is_null($duration) && !(is_int($duration) || ctype_digit($duration))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($duration, true), gettype($duration)), __LINE__);
        }
        $this->Duration = $duration;
        return $this;
    }
    /**
     * Get BeginWeekDays value
     * @return \ArrayType\ArrayOfDayOfWeek|null
     */
    public function getBeginWeekDays()
    {
        return $this->BeginWeekDays;
    }
    /**
     * Set BeginWeekDays value
     * @param \ArrayType\ArrayOfDayOfWeek $beginWeekDays
     * @return \StructType\Period
     */
    public function setBeginWeekDays(\ArrayType\ArrayOfDayOfWeek $beginWeekDays = null)
    {
        $this->BeginWeekDays = $beginWeekDays;
        return $this;
    }
    /**
     * Get EndWeekDays value
     * @return \ArrayType\ArrayOfDayOfWeek|null
     */
    public function getEndWeekDays()
    {
        return $this->EndWeekDays;
    }
    /**
     * Set EndWeekDays value
     * @param \ArrayType\ArrayOfDayOfWeek $endWeekDays
     * @return \StructType\Period
     */
    public function setEndWeekDays(\ArrayType\ArrayOfDayOfWeek $endWeekDays = null)
    {
        $this->EndWeekDays = $endWeekDays;
        return $this;
    }
    /**
     * Get Label value
     * @return string|null
     */
    public function getLabel()
    {
        return $this->Label;
    }
    /**
     * Set Label value
     * @param string $label
     * @return \StructType\Period
     */
    public function setLabel($label = null)
    {
        // validation for constraint: string
        if (!is_null($label) && !is_string($label)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($label, true), gettype($label)), __LINE__);
        }
        $this->Label = $label;
        return $this;
    }
}
