<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AbandonementCartRequest StructType
 * @subpackage Structs
 */
class AbandonementCartRequest extends AbstractStructBase
{
    /**
     * The EstablishementId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $EstablishementId;
    /**
     * The Price
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Price;
    /**
     * The TaxesPrice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $TaxesPrice;
    /**
     * The Optin
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $Optin;
    /**
     * The ClientName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ClientName;
    /**
     * The ClientFirstName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ClientFirstName;
    /**
     * The ClientLang
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ClientLang;
    /**
     * The ClientEmail
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ClientEmail;
    /**
     * The Comment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Comment;
    /**
     * The Tac
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Tac;
    /**
     * The Spec
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Spec;
    /**
     * The Options
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfOption1
     */
    public $Options;
    /**
     * The BirthDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BirthDate;
    /**
     * The Adress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Adress;
    /**
     * The PostCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PostCode;
    /**
     * The Town
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Town;
    /**
     * The Country
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Country;
    /**
     * The Tel
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Tel;
    /**
     * The Mobile
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Mobile;
    /**
     * The InfoPicth
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\InfoPicth
     */
    public $InfoPicth;
    /**
     * The AccompanyingPerson
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfAccompanyingPersonCartData
     */
    public $AccompanyingPerson;
    /**
     * The DiscountCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DiscountCode;
    /**
     * The Insurances
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfInsurance
     */
    public $Insurances;
    /**
     * The CartExternalBookingUrl
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CartExternalBookingUrl;
    /**
     * The CartExternalProductInfoUrl
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CartExternalProductInfoUrl;
    /**
     * Constructor method for AbandonementCartRequest
     * @uses AbandonementCartRequest::setEstablishementId()
     * @uses AbandonementCartRequest::setPrice()
     * @uses AbandonementCartRequest::setTaxesPrice()
     * @uses AbandonementCartRequest::setOptin()
     * @uses AbandonementCartRequest::setClientName()
     * @uses AbandonementCartRequest::setClientFirstName()
     * @uses AbandonementCartRequest::setClientLang()
     * @uses AbandonementCartRequest::setClientEmail()
     * @uses AbandonementCartRequest::setComment()
     * @uses AbandonementCartRequest::setTac()
     * @uses AbandonementCartRequest::setSpec()
     * @uses AbandonementCartRequest::setOptions()
     * @uses AbandonementCartRequest::setBirthDate()
     * @uses AbandonementCartRequest::setAdress()
     * @uses AbandonementCartRequest::setPostCode()
     * @uses AbandonementCartRequest::setTown()
     * @uses AbandonementCartRequest::setCountry()
     * @uses AbandonementCartRequest::setTel()
     * @uses AbandonementCartRequest::setMobile()
     * @uses AbandonementCartRequest::setInfoPicth()
     * @uses AbandonementCartRequest::setAccompanyingPerson()
     * @uses AbandonementCartRequest::setDiscountCode()
     * @uses AbandonementCartRequest::setInsurances()
     * @uses AbandonementCartRequest::setCartExternalBookingUrl()
     * @uses AbandonementCartRequest::setCartExternalProductInfoUrl()
     * @param int $establishementId
     * @param float $price
     * @param float $taxesPrice
     * @param bool $optin
     * @param string $clientName
     * @param string $clientFirstName
     * @param string $clientLang
     * @param string $clientEmail
     * @param string $comment
     * @param string $tac
     * @param string $spec
     * @param \ArrayType\ArrayOfOption1 $options
     * @param string $birthDate
     * @param string $adress
     * @param string $postCode
     * @param string $town
     * @param string $country
     * @param string $tel
     * @param string $mobile
     * @param \StructType\InfoPicth $infoPicth
     * @param \ArrayType\ArrayOfAccompanyingPersonCartData $accompanyingPerson
     * @param string $discountCode
     * @param \ArrayType\ArrayOfInsurance $insurances
     * @param string $cartExternalBookingUrl
     * @param string $cartExternalProductInfoUrl
     */
    public function __construct($establishementId = null, $price = null, $taxesPrice = null, $optin = null, $clientName = null, $clientFirstName = null, $clientLang = null, $clientEmail = null, $comment = null, $tac = null, $spec = null, \ArrayType\ArrayOfOption1 $options = null, $birthDate = null, $adress = null, $postCode = null, $town = null, $country = null, $tel = null, $mobile = null, \StructType\InfoPicth $infoPicth = null, \ArrayType\ArrayOfAccompanyingPersonCartData $accompanyingPerson = null, $discountCode = null, \ArrayType\ArrayOfInsurance $insurances = null, $cartExternalBookingUrl = null, $cartExternalProductInfoUrl = null)
    {
        $this
            ->setEstablishementId($establishementId)
            ->setPrice($price)
            ->setTaxesPrice($taxesPrice)
            ->setOptin($optin)
            ->setClientName($clientName)
            ->setClientFirstName($clientFirstName)
            ->setClientLang($clientLang)
            ->setClientEmail($clientEmail)
            ->setComment($comment)
            ->setTac($tac)
            ->setSpec($spec)
            ->setOptions($options)
            ->setBirthDate($birthDate)
            ->setAdress($adress)
            ->setPostCode($postCode)
            ->setTown($town)
            ->setCountry($country)
            ->setTel($tel)
            ->setMobile($mobile)
            ->setInfoPicth($infoPicth)
            ->setAccompanyingPerson($accompanyingPerson)
            ->setDiscountCode($discountCode)
            ->setInsurances($insurances)
            ->setCartExternalBookingUrl($cartExternalBookingUrl)
            ->setCartExternalProductInfoUrl($cartExternalProductInfoUrl);
    }
    /**
     * Get EstablishementId value
     * @return int
     */
    public function getEstablishementId()
    {
        return $this->EstablishementId;
    }
    /**
     * Set EstablishementId value
     * @param int $establishementId
     * @return \StructType\AbandonementCartRequest
     */
    public function setEstablishementId($establishementId = null)
    {
        // validation for constraint: int
        if (!is_null($establishementId) && !(is_int($establishementId) || ctype_digit($establishementId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($establishementId, true), gettype($establishementId)), __LINE__);
        }
        $this->EstablishementId = $establishementId;
        return $this;
    }
    /**
     * Get Price value
     * @return float
     */
    public function getPrice()
    {
        return $this->Price;
    }
    /**
     * Set Price value
     * @param float $price
     * @return \StructType\AbandonementCartRequest
     */
    public function setPrice($price = null)
    {
        // validation for constraint: float
        if (!is_null($price) && !(is_float($price) || is_numeric($price))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($price, true), gettype($price)), __LINE__);
        }
        $this->Price = $price;
        return $this;
    }
    /**
     * Get TaxesPrice value
     * @return float
     */
    public function getTaxesPrice()
    {
        return $this->TaxesPrice;
    }
    /**
     * Set TaxesPrice value
     * @param float $taxesPrice
     * @return \StructType\AbandonementCartRequest
     */
    public function setTaxesPrice($taxesPrice = null)
    {
        // validation for constraint: float
        if (!is_null($taxesPrice) && !(is_float($taxesPrice) || is_numeric($taxesPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxesPrice, true), gettype($taxesPrice)), __LINE__);
        }
        $this->TaxesPrice = $taxesPrice;
        return $this;
    }
    /**
     * Get Optin value
     * @return bool
     */
    public function getOptin()
    {
        return $this->Optin;
    }
    /**
     * Set Optin value
     * @param bool $optin
     * @return \StructType\AbandonementCartRequest
     */
    public function setOptin($optin = null)
    {
        // validation for constraint: boolean
        if (!is_null($optin) && !is_bool($optin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($optin, true), gettype($optin)), __LINE__);
        }
        $this->Optin = $optin;
        return $this;
    }
    /**
     * Get ClientName value
     * @return string|null
     */
    public function getClientName()
    {
        return $this->ClientName;
    }
    /**
     * Set ClientName value
     * @param string $clientName
     * @return \StructType\AbandonementCartRequest
     */
    public function setClientName($clientName = null)
    {
        // validation for constraint: string
        if (!is_null($clientName) && !is_string($clientName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientName, true), gettype($clientName)), __LINE__);
        }
        $this->ClientName = $clientName;
        return $this;
    }
    /**
     * Get ClientFirstName value
     * @return string|null
     */
    public function getClientFirstName()
    {
        return $this->ClientFirstName;
    }
    /**
     * Set ClientFirstName value
     * @param string $clientFirstName
     * @return \StructType\AbandonementCartRequest
     */
    public function setClientFirstName($clientFirstName = null)
    {
        // validation for constraint: string
        if (!is_null($clientFirstName) && !is_string($clientFirstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientFirstName, true), gettype($clientFirstName)), __LINE__);
        }
        $this->ClientFirstName = $clientFirstName;
        return $this;
    }
    /**
     * Get ClientLang value
     * @return string|null
     */
    public function getClientLang()
    {
        return $this->ClientLang;
    }
    /**
     * Set ClientLang value
     * @param string $clientLang
     * @return \StructType\AbandonementCartRequest
     */
    public function setClientLang($clientLang = null)
    {
        // validation for constraint: string
        if (!is_null($clientLang) && !is_string($clientLang)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientLang, true), gettype($clientLang)), __LINE__);
        }
        $this->ClientLang = $clientLang;
        return $this;
    }
    /**
     * Get ClientEmail value
     * @return string|null
     */
    public function getClientEmail()
    {
        return $this->ClientEmail;
    }
    /**
     * Set ClientEmail value
     * @param string $clientEmail
     * @return \StructType\AbandonementCartRequest
     */
    public function setClientEmail($clientEmail = null)
    {
        // validation for constraint: string
        if (!is_null($clientEmail) && !is_string($clientEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientEmail, true), gettype($clientEmail)), __LINE__);
        }
        $this->ClientEmail = $clientEmail;
        return $this;
    }
    /**
     * Get Comment value
     * @return string|null
     */
    public function getComment()
    {
        return $this->Comment;
    }
    /**
     * Set Comment value
     * @param string $comment
     * @return \StructType\AbandonementCartRequest
     */
    public function setComment($comment = null)
    {
        // validation for constraint: string
        if (!is_null($comment) && !is_string($comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comment, true), gettype($comment)), __LINE__);
        }
        $this->Comment = $comment;
        return $this;
    }
    /**
     * Get Tac value
     * @return string|null
     */
    public function getTac()
    {
        return $this->Tac;
    }
    /**
     * Set Tac value
     * @param string $tac
     * @return \StructType\AbandonementCartRequest
     */
    public function setTac($tac = null)
    {
        // validation for constraint: string
        if (!is_null($tac) && !is_string($tac)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tac, true), gettype($tac)), __LINE__);
        }
        $this->Tac = $tac;
        return $this;
    }
    /**
     * Get Spec value
     * @return string|null
     */
    public function getSpec()
    {
        return $this->Spec;
    }
    /**
     * Set Spec value
     * @param string $spec
     * @return \StructType\AbandonementCartRequest
     */
    public function setSpec($spec = null)
    {
        // validation for constraint: string
        if (!is_null($spec) && !is_string($spec)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($spec, true), gettype($spec)), __LINE__);
        }
        $this->Spec = $spec;
        return $this;
    }
    /**
     * Get Options value
     * @return \ArrayType\ArrayOfOption1|null
     */
    public function getOptions()
    {
        return $this->Options;
    }
    /**
     * Set Options value
     * @param \ArrayType\ArrayOfOption1 $options
     * @return \StructType\AbandonementCartRequest
     */
    public function setOptions(\ArrayType\ArrayOfOption1 $options = null)
    {
        $this->Options = $options;
        return $this;
    }
    /**
     * Get BirthDate value
     * @return string|null
     */
    public function getBirthDate()
    {
        return $this->BirthDate;
    }
    /**
     * Set BirthDate value
     * @param string $birthDate
     * @return \StructType\AbandonementCartRequest
     */
    public function setBirthDate($birthDate = null)
    {
        // validation for constraint: string
        if (!is_null($birthDate) && !is_string($birthDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($birthDate, true), gettype($birthDate)), __LINE__);
        }
        $this->BirthDate = $birthDate;
        return $this;
    }
    /**
     * Get Adress value
     * @return string|null
     */
    public function getAdress()
    {
        return $this->Adress;
    }
    /**
     * Set Adress value
     * @param string $adress
     * @return \StructType\AbandonementCartRequest
     */
    public function setAdress($adress = null)
    {
        // validation for constraint: string
        if (!is_null($adress) && !is_string($adress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adress, true), gettype($adress)), __LINE__);
        }
        $this->Adress = $adress;
        return $this;
    }
    /**
     * Get PostCode value
     * @return string|null
     */
    public function getPostCode()
    {
        return $this->PostCode;
    }
    /**
     * Set PostCode value
     * @param string $postCode
     * @return \StructType\AbandonementCartRequest
     */
    public function setPostCode($postCode = null)
    {
        // validation for constraint: string
        if (!is_null($postCode) && !is_string($postCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postCode, true), gettype($postCode)), __LINE__);
        }
        $this->PostCode = $postCode;
        return $this;
    }
    /**
     * Get Town value
     * @return string|null
     */
    public function getTown()
    {
        return $this->Town;
    }
    /**
     * Set Town value
     * @param string $town
     * @return \StructType\AbandonementCartRequest
     */
    public function setTown($town = null)
    {
        // validation for constraint: string
        if (!is_null($town) && !is_string($town)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($town, true), gettype($town)), __LINE__);
        }
        $this->Town = $town;
        return $this;
    }
    /**
     * Get Country value
     * @return string|null
     */
    public function getCountry()
    {
        return $this->Country;
    }
    /**
     * Set Country value
     * @param string $country
     * @return \StructType\AbandonementCartRequest
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($country, true), gettype($country)), __LINE__);
        }
        $this->Country = $country;
        return $this;
    }
    /**
     * Get Tel value
     * @return string|null
     */
    public function getTel()
    {
        return $this->Tel;
    }
    /**
     * Set Tel value
     * @param string $tel
     * @return \StructType\AbandonementCartRequest
     */
    public function setTel($tel = null)
    {
        // validation for constraint: string
        if (!is_null($tel) && !is_string($tel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tel, true), gettype($tel)), __LINE__);
        }
        $this->Tel = $tel;
        return $this;
    }
    /**
     * Get Mobile value
     * @return string|null
     */
    public function getMobile()
    {
        return $this->Mobile;
    }
    /**
     * Set Mobile value
     * @param string $mobile
     * @return \StructType\AbandonementCartRequest
     */
    public function setMobile($mobile = null)
    {
        // validation for constraint: string
        if (!is_null($mobile) && !is_string($mobile)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mobile, true), gettype($mobile)), __LINE__);
        }
        $this->Mobile = $mobile;
        return $this;
    }
    /**
     * Get InfoPicth value
     * @return \StructType\InfoPicth|null
     */
    public function getInfoPicth()
    {
        return $this->InfoPicth;
    }
    /**
     * Set InfoPicth value
     * @param \StructType\InfoPicth $infoPicth
     * @return \StructType\AbandonementCartRequest
     */
    public function setInfoPicth(\StructType\InfoPicth $infoPicth = null)
    {
        $this->InfoPicth = $infoPicth;
        return $this;
    }
    /**
     * Get AccompanyingPerson value
     * @return \ArrayType\ArrayOfAccompanyingPersonCartData|null
     */
    public function getAccompanyingPerson()
    {
        return $this->AccompanyingPerson;
    }
    /**
     * Set AccompanyingPerson value
     * @param \ArrayType\ArrayOfAccompanyingPersonCartData $accompanyingPerson
     * @return \StructType\AbandonementCartRequest
     */
    public function setAccompanyingPerson(\ArrayType\ArrayOfAccompanyingPersonCartData $accompanyingPerson = null)
    {
        $this->AccompanyingPerson = $accompanyingPerson;
        return $this;
    }
    /**
     * Get DiscountCode value
     * @return string|null
     */
    public function getDiscountCode()
    {
        return $this->DiscountCode;
    }
    /**
     * Set DiscountCode value
     * @param string $discountCode
     * @return \StructType\AbandonementCartRequest
     */
    public function setDiscountCode($discountCode = null)
    {
        // validation for constraint: string
        if (!is_null($discountCode) && !is_string($discountCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($discountCode, true), gettype($discountCode)), __LINE__);
        }
        $this->DiscountCode = $discountCode;
        return $this;
    }
    /**
     * Get Insurances value
     * @return \ArrayType\ArrayOfInsurance|null
     */
    public function getInsurances()
    {
        return $this->Insurances;
    }
    /**
     * Set Insurances value
     * @param \ArrayType\ArrayOfInsurance $insurances
     * @return \StructType\AbandonementCartRequest
     */
    public function setInsurances(\ArrayType\ArrayOfInsurance $insurances = null)
    {
        $this->Insurances = $insurances;
        return $this;
    }
    /**
     * Get CartExternalBookingUrl value
     * @return string|null
     */
    public function getCartExternalBookingUrl()
    {
        return $this->CartExternalBookingUrl;
    }
    /**
     * Set CartExternalBookingUrl value
     * @param string $cartExternalBookingUrl
     * @return \StructType\AbandonementCartRequest
     */
    public function setCartExternalBookingUrl($cartExternalBookingUrl = null)
    {
        // validation for constraint: string
        if (!is_null($cartExternalBookingUrl) && !is_string($cartExternalBookingUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cartExternalBookingUrl, true), gettype($cartExternalBookingUrl)), __LINE__);
        }
        $this->CartExternalBookingUrl = $cartExternalBookingUrl;
        return $this;
    }
    /**
     * Get CartExternalProductInfoUrl value
     * @return string|null
     */
    public function getCartExternalProductInfoUrl()
    {
        return $this->CartExternalProductInfoUrl;
    }
    /**
     * Set CartExternalProductInfoUrl value
     * @param string $cartExternalProductInfoUrl
     * @return \StructType\AbandonementCartRequest
     */
    public function setCartExternalProductInfoUrl($cartExternalProductInfoUrl = null)
    {
        // validation for constraint: string
        if (!is_null($cartExternalProductInfoUrl) && !is_string($cartExternalProductInfoUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cartExternalProductInfoUrl, true), gettype($cartExternalProductInfoUrl)), __LINE__);
        }
        $this->CartExternalProductInfoUrl = $cartExternalProductInfoUrl;
        return $this;
    }
}
