<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for option StructType
 * @subpackage Structs
 */
class Option extends AbstractStructBase
{
    /**
     * The optionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $optionID;
    /**
     * The optionPrice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $optionPrice;
    /**
     * The optionNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $optionNumber;
    /**
     * The optionQuantityMax
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $optionQuantityMax;
    /**
     * The optionQuantityMin
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $optionQuantityMin;
    /**
     * The optionQuantityIncluded
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $optionQuantityIncluded;
    /**
     * The optionPersType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $optionPersType;
    /**
     * The optionBy
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $optionBy;
    /**
     * The optionIndex
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $optionIndex;
    /**
     * The optionMandatory
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $optionMandatory;
    /**
     * The ageMin
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $ageMin;
    /**
     * The ageMax
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $ageMax;
    /**
     * The optionPriceWithoutOffer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $optionPriceWithoutOffer;
    /**
     * The label
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $label;
    /**
     * The optionPeriodicity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $optionPeriodicity;
    /**
     * The OptionPeriodList
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfOptionPeriod
     */
    public $OptionPeriodList;
    /**
     * Constructor method for option
     * @uses Option::setOptionID()
     * @uses Option::setOptionPrice()
     * @uses Option::setOptionNumber()
     * @uses Option::setOptionQuantityMax()
     * @uses Option::setOptionQuantityMin()
     * @uses Option::setOptionQuantityIncluded()
     * @uses Option::setOptionPersType()
     * @uses Option::setOptionBy()
     * @uses Option::setOptionIndex()
     * @uses Option::setOptionMandatory()
     * @uses Option::setAgeMin()
     * @uses Option::setAgeMax()
     * @uses Option::setOptionPriceWithoutOffer()
     * @uses Option::setLabel()
     * @uses Option::setOptionPeriodicity()
     * @uses Option::setOptionPeriodList()
     * @param int $optionID
     * @param float $optionPrice
     * @param int $optionNumber
     * @param int $optionQuantityMax
     * @param int $optionQuantityMin
     * @param int $optionQuantityIncluded
     * @param string $optionPersType
     * @param int $optionBy
     * @param int $optionIndex
     * @param bool $optionMandatory
     * @param int $ageMin
     * @param int $ageMax
     * @param float $optionPriceWithoutOffer
     * @param string $label
     * @param string $optionPeriodicity
     * @param \ArrayType\ArrayOfOptionPeriod $optionPeriodList
     */
    public function __construct($optionID = null, $optionPrice = null, $optionNumber = null, $optionQuantityMax = null, $optionQuantityMin = null, $optionQuantityIncluded = null, $optionPersType = null, $optionBy = null, $optionIndex = null, $optionMandatory = null, $ageMin = null, $ageMax = null, $optionPriceWithoutOffer = null, $label = null, $optionPeriodicity = null, \ArrayType\ArrayOfOptionPeriod $optionPeriodList = null)
    {
        $this
            ->setOptionID($optionID)
            ->setOptionPrice($optionPrice)
            ->setOptionNumber($optionNumber)
            ->setOptionQuantityMax($optionQuantityMax)
            ->setOptionQuantityMin($optionQuantityMin)
            ->setOptionQuantityIncluded($optionQuantityIncluded)
            ->setOptionPersType($optionPersType)
            ->setOptionBy($optionBy)
            ->setOptionIndex($optionIndex)
            ->setOptionMandatory($optionMandatory)
            ->setAgeMin($ageMin)
            ->setAgeMax($ageMax)
            ->setOptionPriceWithoutOffer($optionPriceWithoutOffer)
            ->setLabel($label)
            ->setOptionPeriodicity($optionPeriodicity)
            ->setOptionPeriodList($optionPeriodList);
    }
    /**
     * Get optionID value
     * @return int
     */
    public function getOptionID()
    {
        return $this->optionID;
    }
    /**
     * Set optionID value
     * @param int $optionID
     * @return \StructType\Option
     */
    public function setOptionID($optionID = null)
    {
        // validation for constraint: int
        if (!is_null($optionID) && !(is_int($optionID) || ctype_digit($optionID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($optionID, true), gettype($optionID)), __LINE__);
        }
        $this->optionID = $optionID;
        return $this;
    }
    /**
     * Get optionPrice value
     * @return float
     */
    public function getOptionPrice()
    {
        return $this->optionPrice;
    }
    /**
     * Set optionPrice value
     * @param float $optionPrice
     * @return \StructType\Option
     */
    public function setOptionPrice($optionPrice = null)
    {
        // validation for constraint: float
        if (!is_null($optionPrice) && !(is_float($optionPrice) || is_numeric($optionPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($optionPrice, true), gettype($optionPrice)), __LINE__);
        }
        $this->optionPrice = $optionPrice;
        return $this;
    }
    /**
     * Get optionNumber value
     * @return int
     */
    public function getOptionNumber()
    {
        return $this->optionNumber;
    }
    /**
     * Set optionNumber value
     * @param int $optionNumber
     * @return \StructType\Option
     */
    public function setOptionNumber($optionNumber = null)
    {
        // validation for constraint: int
        if (!is_null($optionNumber) && !(is_int($optionNumber) || ctype_digit($optionNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($optionNumber, true), gettype($optionNumber)), __LINE__);
        }
        $this->optionNumber = $optionNumber;
        return $this;
    }
    /**
     * Get optionQuantityMax value
     * @return int
     */
    public function getOptionQuantityMax()
    {
        return $this->optionQuantityMax;
    }
    /**
     * Set optionQuantityMax value
     * @param int $optionQuantityMax
     * @return \StructType\Option
     */
    public function setOptionQuantityMax($optionQuantityMax = null)
    {
        // validation for constraint: int
        if (!is_null($optionQuantityMax) && !(is_int($optionQuantityMax) || ctype_digit($optionQuantityMax))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($optionQuantityMax, true), gettype($optionQuantityMax)), __LINE__);
        }
        $this->optionQuantityMax = $optionQuantityMax;
        return $this;
    }
    /**
     * Get optionQuantityMin value
     * @return int
     */
    public function getOptionQuantityMin()
    {
        return $this->optionQuantityMin;
    }
    /**
     * Set optionQuantityMin value
     * @param int $optionQuantityMin
     * @return \StructType\Option
     */
    public function setOptionQuantityMin($optionQuantityMin = null)
    {
        // validation for constraint: int
        if (!is_null($optionQuantityMin) && !(is_int($optionQuantityMin) || ctype_digit($optionQuantityMin))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($optionQuantityMin, true), gettype($optionQuantityMin)), __LINE__);
        }
        $this->optionQuantityMin = $optionQuantityMin;
        return $this;
    }
    /**
     * Get optionQuantityIncluded value
     * @return int
     */
    public function getOptionQuantityIncluded()
    {
        return $this->optionQuantityIncluded;
    }
    /**
     * Set optionQuantityIncluded value
     * @param int $optionQuantityIncluded
     * @return \StructType\Option
     */
    public function setOptionQuantityIncluded($optionQuantityIncluded = null)
    {
        // validation for constraint: int
        if (!is_null($optionQuantityIncluded) && !(is_int($optionQuantityIncluded) || ctype_digit($optionQuantityIncluded))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($optionQuantityIncluded, true), gettype($optionQuantityIncluded)), __LINE__);
        }
        $this->optionQuantityIncluded = $optionQuantityIncluded;
        return $this;
    }
    /**
     * Get optionPersType value
     * @return string
     */
    public function getOptionPersType()
    {
        return $this->optionPersType;
    }
    /**
     * Set optionPersType value
     * @uses \EnumType\OptionPersType::valueIsValid()
     * @uses \EnumType\OptionPersType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $optionPersType
     * @return \StructType\Option
     */
    public function setOptionPersType($optionPersType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\OptionPersType::valueIsValid($optionPersType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\OptionPersType', is_array($optionPersType) ? implode(', ', $optionPersType) : var_export($optionPersType, true), implode(', ', \EnumType\OptionPersType::getValidValues())), __LINE__);
        }
        $this->optionPersType = $optionPersType;
        return $this;
    }
    /**
     * Get optionBy value
     * @return int
     */
    public function getOptionBy()
    {
        return $this->optionBy;
    }
    /**
     * Set optionBy value
     * @param int $optionBy
     * @return \StructType\Option
     */
    public function setOptionBy($optionBy = null)
    {
        // validation for constraint: int
        if (!is_null($optionBy) && !(is_int($optionBy) || ctype_digit($optionBy))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($optionBy, true), gettype($optionBy)), __LINE__);
        }
        $this->optionBy = $optionBy;
        return $this;
    }
    /**
     * Get optionIndex value
     * @return int
     */
    public function getOptionIndex()
    {
        return $this->optionIndex;
    }
    /**
     * Set optionIndex value
     * @param int $optionIndex
     * @return \StructType\Option
     */
    public function setOptionIndex($optionIndex = null)
    {
        // validation for constraint: int
        if (!is_null($optionIndex) && !(is_int($optionIndex) || ctype_digit($optionIndex))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($optionIndex, true), gettype($optionIndex)), __LINE__);
        }
        $this->optionIndex = $optionIndex;
        return $this;
    }
    /**
     * Get optionMandatory value
     * @return bool
     */
    public function getOptionMandatory()
    {
        return $this->optionMandatory;
    }
    /**
     * Set optionMandatory value
     * @param bool $optionMandatory
     * @return \StructType\Option
     */
    public function setOptionMandatory($optionMandatory = null)
    {
        // validation for constraint: boolean
        if (!is_null($optionMandatory) && !is_bool($optionMandatory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($optionMandatory, true), gettype($optionMandatory)), __LINE__);
        }
        $this->optionMandatory = $optionMandatory;
        return $this;
    }
    /**
     * Get ageMin value
     * @return int
     */
    public function getAgeMin()
    {
        return $this->ageMin;
    }
    /**
     * Set ageMin value
     * @param int $ageMin
     * @return \StructType\Option
     */
    public function setAgeMin($ageMin = null)
    {
        // validation for constraint: int
        if (!is_null($ageMin) && !(is_int($ageMin) || ctype_digit($ageMin))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ageMin, true), gettype($ageMin)), __LINE__);
        }
        $this->ageMin = $ageMin;
        return $this;
    }
    /**
     * Get ageMax value
     * @return int
     */
    public function getAgeMax()
    {
        return $this->ageMax;
    }
    /**
     * Set ageMax value
     * @param int $ageMax
     * @return \StructType\Option
     */
    public function setAgeMax($ageMax = null)
    {
        // validation for constraint: int
        if (!is_null($ageMax) && !(is_int($ageMax) || ctype_digit($ageMax))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ageMax, true), gettype($ageMax)), __LINE__);
        }
        $this->ageMax = $ageMax;
        return $this;
    }
    /**
     * Get optionPriceWithoutOffer value
     * @return float
     */
    public function getOptionPriceWithoutOffer()
    {
        return $this->optionPriceWithoutOffer;
    }
    /**
     * Set optionPriceWithoutOffer value
     * @param float $optionPriceWithoutOffer
     * @return \StructType\Option
     */
    public function setOptionPriceWithoutOffer($optionPriceWithoutOffer = null)
    {
        // validation for constraint: float
        if (!is_null($optionPriceWithoutOffer) && !(is_float($optionPriceWithoutOffer) || is_numeric($optionPriceWithoutOffer))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($optionPriceWithoutOffer, true), gettype($optionPriceWithoutOffer)), __LINE__);
        }
        $this->optionPriceWithoutOffer = $optionPriceWithoutOffer;
        return $this;
    }
    /**
     * Get label value
     * @return string|null
     */
    public function getLabel()
    {
        return $this->label;
    }
    /**
     * Set label value
     * @param string $label
     * @return \StructType\Option
     */
    public function setLabel($label = null)
    {
        // validation for constraint: string
        if (!is_null($label) && !is_string($label)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($label, true), gettype($label)), __LINE__);
        }
        $this->label = $label;
        return $this;
    }
    /**
     * Get optionPeriodicity value
     * @return string|null
     */
    public function getOptionPeriodicity()
    {
        return $this->optionPeriodicity;
    }
    /**
     * Set optionPeriodicity value
     * @param string $optionPeriodicity
     * @return \StructType\Option
     */
    public function setOptionPeriodicity($optionPeriodicity = null)
    {
        // validation for constraint: string
        if (!is_null($optionPeriodicity) && !is_string($optionPeriodicity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($optionPeriodicity, true), gettype($optionPeriodicity)), __LINE__);
        }
        $this->optionPeriodicity = $optionPeriodicity;
        return $this;
    }
    /**
     * Get OptionPeriodList value
     * @return \ArrayType\ArrayOfOptionPeriod|null
     */
    public function getOptionPeriodList()
    {
        return $this->OptionPeriodList;
    }
    /**
     * Set OptionPeriodList value
     * @param \ArrayType\ArrayOfOptionPeriod $optionPeriodList
     * @return \StructType\Option
     */
    public function setOptionPeriodList(\ArrayType\ArrayOfOptionPeriod $optionPeriodList = null)
    {
        $this->OptionPeriodList = $optionPeriodList;
        return $this;
    }
}
