<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for WeekEndOrNotEnum EnumType
 * @subpackage Enumerations
 */
class WeekEndOrNotEnum extends AbstractStructEnumBase
{
    /**
     * Constant for value 'Both'
     * @return string 'Both'
     */
    const VALUE_BOTH = 'Both';
    /**
     * Constant for value 'NotWeekend'
     * @return string 'NotWeekend'
     */
    const VALUE_NOT_WEEKEND = 'NotWeekend';
    /**
     * Constant for value 'Weekend'
     * @return string 'Weekend'
     */
    const VALUE_WEEKEND = 'Weekend';
    /**
     * Return allowed values
     * @uses self::VALUE_BOTH
     * @uses self::VALUE_NOT_WEEKEND
     * @uses self::VALUE_WEEKEND
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_BOTH,
            self::VALUE_NOT_WEEKEND,
            self::VALUE_WEEKEND,
        );
    }
}
