<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfSeasonEnum ArrayType
 * @subpackage Arrays
 */
class ArrayOfSeasonEnum extends AbstractStructArrayBase
{
    /**
     * The seasonEnum
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $seasonEnum;
    /**
     * Constructor method for ArrayOfSeasonEnum
     * @uses ArrayOfSeasonEnum::setSeasonEnum()
     * @param string[] $seasonEnum
     */
    public function __construct(array $seasonEnum = array())
    {
        $this
            ->setSeasonEnum($seasonEnum);
    }
    /**
     * Get seasonEnum value
     * @return string[]|null
     */
    public function getSeasonEnum()
    {
        return $this->seasonEnum;
    }
    /**
     * This method is responsible for validating the values passed to the setSeasonEnum method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSeasonEnum method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSeasonEnumForArrayConstraintsFromSetSeasonEnum(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfSeasonEnumSeasonEnumItem) {
            // validation for constraint: enumeration
            if (!\EnumType\SeasonEnum::valueIsValid($arrayOfSeasonEnumSeasonEnumItem)) {
                $invalidValues[] = is_object($arrayOfSeasonEnumSeasonEnumItem) ? get_class($arrayOfSeasonEnumSeasonEnumItem) : sprintf('%s(%s)', gettype($arrayOfSeasonEnumSeasonEnumItem), var_export($arrayOfSeasonEnumSeasonEnumItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\SeasonEnum', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\SeasonEnum::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set seasonEnum value
     * @uses \EnumType\SeasonEnum::valueIsValid()
     * @uses \EnumType\SeasonEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $seasonEnum
     * @return \ArrayType\ArrayOfSeasonEnum
     */
    public function setSeasonEnum(array $seasonEnum = array())
    {
        // validation for constraint: array
        if ('' !== ($seasonEnumArrayErrorMessage = self::validateSeasonEnumForArrayConstraintsFromSetSeasonEnum($seasonEnum))) {
            throw new \InvalidArgumentException($seasonEnumArrayErrorMessage, __LINE__);
        }
        $this->seasonEnum = $seasonEnum;
        return $this;
    }
    /**
     * Add item to seasonEnum value
     * @uses \EnumType\SeasonEnum::valueIsValid()
     * @uses \EnumType\SeasonEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \ArrayType\ArrayOfSeasonEnum
     */
    public function addToSeasonEnum($item)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SeasonEnum::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\SeasonEnum', is_array($item) ? implode(', ', $item) : var_export($item, true), implode(', ', \EnumType\SeasonEnum::getValidValues())), __LINE__);
        }
        $this->seasonEnum[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return string|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return string|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return string|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return string|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return string|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Add element to array
     * @see AbstractStructArrayBase::add()
     * @throws \InvalidArgumentException
     * @uses \EnumType\SeasonEnum::valueIsValid()
     * @param string $item
     * @return \ArrayType\ArrayOfSeasonEnum
     */
    public function add($item)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SeasonEnum::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\SeasonEnum', is_array($item) ? implode(', ', $item) : var_export($item, true), implode(', ', \EnumType\SeasonEnum::getValidValues())), __LINE__);
        }
        return parent::add($item);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string seasonEnum
     */
    public function getAttributeName()
    {
        return 'seasonEnum';
    }
}
