<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AbandonementCartInformations StructType
 * @subpackage Structs
 */
class AbandonementCartInformations extends AbstractStructBase
{
    /**
     * The CartGuid
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $CartGuid;
    /**
     * The CartId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CartId;
    /**
     * The EstablishmentId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $EstablishmentId;
    /**
     * The EngineId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $EngineId;
    /**
     * The CreationDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CreationDate;
    /**
     * The TunnelOriginalBooking
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TunnelOriginalBooking
     */
    public $TunnelOriginalBooking;
    /**
     * The TunnelSpecialParams
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TunnelSpecialParams
     */
    public $TunnelSpecialParams;
    /**
     * The TunnelOptionList
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfTunnelOption
     */
    public $TunnelOptionList;
    /**
     * The TunnelPrices
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TunnelCartPrices
     */
    public $TunnelPrices;
    /**
     * The TunnelStay
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TunnelStay
     */
    public $TunnelStay;
    /**
     * The TunnelCartInformation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TunnelCartInformation
     */
    public $TunnelCartInformation;
    /**
     * Constructor method for AbandonementCartInformations
     * @uses AbandonementCartInformations::setCartGuid()
     * @uses AbandonementCartInformations::setCartId()
     * @uses AbandonementCartInformations::setEstablishmentId()
     * @uses AbandonementCartInformations::setEngineId()
     * @uses AbandonementCartInformations::setCreationDate()
     * @uses AbandonementCartInformations::setTunnelOriginalBooking()
     * @uses AbandonementCartInformations::setTunnelSpecialParams()
     * @uses AbandonementCartInformations::setTunnelOptionList()
     * @uses AbandonementCartInformations::setTunnelPrices()
     * @uses AbandonementCartInformations::setTunnelStay()
     * @uses AbandonementCartInformations::setTunnelCartInformation()
     * @param string $cartGuid
     * @param int $cartId
     * @param int $establishmentId
     * @param int $engineId
     * @param string $creationDate
     * @param \StructType\TunnelOriginalBooking $tunnelOriginalBooking
     * @param \StructType\TunnelSpecialParams $tunnelSpecialParams
     * @param \ArrayType\ArrayOfTunnelOption $tunnelOptionList
     * @param \StructType\TunnelCartPrices $tunnelPrices
     * @param \StructType\TunnelStay $tunnelStay
     * @param \StructType\TunnelCartInformation $tunnelCartInformation
     */
    public function __construct($cartGuid = null, $cartId = null, $establishmentId = null, $engineId = null, $creationDate = null, \StructType\TunnelOriginalBooking $tunnelOriginalBooking = null, \StructType\TunnelSpecialParams $tunnelSpecialParams = null, \ArrayType\ArrayOfTunnelOption $tunnelOptionList = null, \StructType\TunnelCartPrices $tunnelPrices = null, \StructType\TunnelStay $tunnelStay = null, \StructType\TunnelCartInformation $tunnelCartInformation = null)
    {
        $this
            ->setCartGuid($cartGuid)
            ->setCartId($cartId)
            ->setEstablishmentId($establishmentId)
            ->setEngineId($engineId)
            ->setCreationDate($creationDate)
            ->setTunnelOriginalBooking($tunnelOriginalBooking)
            ->setTunnelSpecialParams($tunnelSpecialParams)
            ->setTunnelOptionList($tunnelOptionList)
            ->setTunnelPrices($tunnelPrices)
            ->setTunnelStay($tunnelStay)
            ->setTunnelCartInformation($tunnelCartInformation);
    }
    /**
     * Get CartGuid value
     * @return string
     */
    public function getCartGuid()
    {
        return $this->CartGuid;
    }
    /**
     * Set CartGuid value
     * @param string $cartGuid
     * @return \StructType\AbandonementCartInformations
     */
    public function setCartGuid($cartGuid = null)
    {
        // validation for constraint: string
        if (!is_null($cartGuid) && !is_string($cartGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cartGuid, true), gettype($cartGuid)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($cartGuid) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $cartGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($cartGuid, true)), __LINE__);
        }
        $this->CartGuid = $cartGuid;
        return $this;
    }
    /**
     * Get CartId value
     * @return int
     */
    public function getCartId()
    {
        return $this->CartId;
    }
    /**
     * Set CartId value
     * @param int $cartId
     * @return \StructType\AbandonementCartInformations
     */
    public function setCartId($cartId = null)
    {
        // validation for constraint: int
        if (!is_null($cartId) && !(is_int($cartId) || ctype_digit($cartId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cartId, true), gettype($cartId)), __LINE__);
        }
        $this->CartId = $cartId;
        return $this;
    }
    /**
     * Get EstablishmentId value
     * @return int
     */
    public function getEstablishmentId()
    {
        return $this->EstablishmentId;
    }
    /**
     * Set EstablishmentId value
     * @param int $establishmentId
     * @return \StructType\AbandonementCartInformations
     */
    public function setEstablishmentId($establishmentId = null)
    {
        // validation for constraint: int
        if (!is_null($establishmentId) && !(is_int($establishmentId) || ctype_digit($establishmentId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($establishmentId, true), gettype($establishmentId)), __LINE__);
        }
        $this->EstablishmentId = $establishmentId;
        return $this;
    }
    /**
     * Get EngineId value
     * @return int
     */
    public function getEngineId()
    {
        return $this->EngineId;
    }
    /**
     * Set EngineId value
     * @param int $engineId
     * @return \StructType\AbandonementCartInformations
     */
    public function setEngineId($engineId = null)
    {
        // validation for constraint: int
        if (!is_null($engineId) && !(is_int($engineId) || ctype_digit($engineId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($engineId, true), gettype($engineId)), __LINE__);
        }
        $this->EngineId = $engineId;
        return $this;
    }
    /**
     * Get CreationDate value
     * @return string
     */
    public function getCreationDate()
    {
        return $this->CreationDate;
    }
    /**
     * Set CreationDate value
     * @param string $creationDate
     * @return \StructType\AbandonementCartInformations
     */
    public function setCreationDate($creationDate = null)
    {
        // validation for constraint: string
        if (!is_null($creationDate) && !is_string($creationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creationDate, true), gettype($creationDate)), __LINE__);
        }
        $this->CreationDate = $creationDate;
        return $this;
    }
    /**
     * Get TunnelOriginalBooking value
     * @return \StructType\TunnelOriginalBooking|null
     */
    public function getTunnelOriginalBooking()
    {
        return $this->TunnelOriginalBooking;
    }
    /**
     * Set TunnelOriginalBooking value
     * @param \StructType\TunnelOriginalBooking $tunnelOriginalBooking
     * @return \StructType\AbandonementCartInformations
     */
    public function setTunnelOriginalBooking(\StructType\TunnelOriginalBooking $tunnelOriginalBooking = null)
    {
        $this->TunnelOriginalBooking = $tunnelOriginalBooking;
        return $this;
    }
    /**
     * Get TunnelSpecialParams value
     * @return \StructType\TunnelSpecialParams|null
     */
    public function getTunnelSpecialParams()
    {
        return $this->TunnelSpecialParams;
    }
    /**
     * Set TunnelSpecialParams value
     * @param \StructType\TunnelSpecialParams $tunnelSpecialParams
     * @return \StructType\AbandonementCartInformations
     */
    public function setTunnelSpecialParams(\StructType\TunnelSpecialParams $tunnelSpecialParams = null)
    {
        $this->TunnelSpecialParams = $tunnelSpecialParams;
        return $this;
    }
    /**
     * Get TunnelOptionList value
     * @return \ArrayType\ArrayOfTunnelOption|null
     */
    public function getTunnelOptionList()
    {
        return $this->TunnelOptionList;
    }
    /**
     * Set TunnelOptionList value
     * @param \ArrayType\ArrayOfTunnelOption $tunnelOptionList
     * @return \StructType\AbandonementCartInformations
     */
    public function setTunnelOptionList(\ArrayType\ArrayOfTunnelOption $tunnelOptionList = null)
    {
        $this->TunnelOptionList = $tunnelOptionList;
        return $this;
    }
    /**
     * Get TunnelPrices value
     * @return \StructType\TunnelCartPrices|null
     */
    public function getTunnelPrices()
    {
        return $this->TunnelPrices;
    }
    /**
     * Set TunnelPrices value
     * @param \StructType\TunnelCartPrices $tunnelPrices
     * @return \StructType\AbandonementCartInformations
     */
    public function setTunnelPrices(\StructType\TunnelCartPrices $tunnelPrices = null)
    {
        $this->TunnelPrices = $tunnelPrices;
        return $this;
    }
    /**
     * Get TunnelStay value
     * @return \StructType\TunnelStay|null
     */
    public function getTunnelStay()
    {
        return $this->TunnelStay;
    }
    /**
     * Set TunnelStay value
     * @param \StructType\TunnelStay $tunnelStay
     * @return \StructType\AbandonementCartInformations
     */
    public function setTunnelStay(\StructType\TunnelStay $tunnelStay = null)
    {
        $this->TunnelStay = $tunnelStay;
        return $this;
    }
    /**
     * Get TunnelCartInformation value
     * @return \StructType\TunnelCartInformation|null
     */
    public function getTunnelCartInformation()
    {
        return $this->TunnelCartInformation;
    }
    /**
     * Set TunnelCartInformation value
     * @param \StructType\TunnelCartInformation $tunnelCartInformation
     * @return \StructType\AbandonementCartInformations
     */
    public function setTunnelCartInformation(\StructType\TunnelCartInformation $tunnelCartInformation = null)
    {
        $this->TunnelCartInformation = $tunnelCartInformation;
        return $this;
    }
}
