<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for productFirstNightPrice StructType
 * @subpackage Structs
 */
class ProductFirstNightPrice extends AbstractStructBase
{
    /**
     * The dayCount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $dayCount;
    /**
     * The price
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $price;
    /**
     * Constructor method for productFirstNightPrice
     * @uses ProductFirstNightPrice::setDayCount()
     * @uses ProductFirstNightPrice::setPrice()
     * @param int $dayCount
     * @param float $price
     */
    public function __construct($dayCount = null, $price = null)
    {
        $this
            ->setDayCount($dayCount)
            ->setPrice($price);
    }
    /**
     * Get dayCount value
     * @return int
     */
    public function getDayCount()
    {
        return $this->dayCount;
    }
    /**
     * Set dayCount value
     * @param int $dayCount
     * @return \StructType\ProductFirstNightPrice
     */
    public function setDayCount($dayCount = null)
    {
        // validation for constraint: int
        if (!is_null($dayCount) && !(is_int($dayCount) || ctype_digit($dayCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($dayCount, true), gettype($dayCount)), __LINE__);
        }
        $this->dayCount = $dayCount;
        return $this;
    }
    /**
     * Get price value
     * @return float
     */
    public function getPrice()
    {
        return $this->price;
    }
    /**
     * Set price value
     * @param float $price
     * @return \StructType\ProductFirstNightPrice
     */
    public function setPrice($price = null)
    {
        // validation for constraint: float
        if (!is_null($price) && !(is_float($price) || is_numeric($price))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($price, true), gettype($price)), __LINE__);
        }
        $this->price = $price;
        return $this;
    }
}
