<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPricesInfo ArrayType
 * @subpackage Arrays
 */
class ArrayOfPricesInfo extends AbstractStructArrayBase
{
    /**
     * The PricesInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PricesInfo[]
     */
    public $PricesInfo;
    /**
     * Constructor method for ArrayOfPricesInfo
     * @uses ArrayOfPricesInfo::setPricesInfo()
     * @param \StructType\PricesInfo[] $pricesInfo
     */
    public function __construct(array $pricesInfo = array())
    {
        $this
            ->setPricesInfo($pricesInfo);
    }
    /**
     * Get PricesInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PricesInfo[]|null
     */
    public function getPricesInfo()
    {
        return isset($this->PricesInfo) ? $this->PricesInfo : null;
    }
    /**
     * This method is responsible for validating the values passed to the setPricesInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPricesInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePricesInfoForArrayConstraintsFromSetPricesInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfPricesInfoPricesInfoItem) {
            // validation for constraint: itemType
            if (!$arrayOfPricesInfoPricesInfoItem instanceof \StructType\PricesInfo) {
                $invalidValues[] = is_object($arrayOfPricesInfoPricesInfoItem) ? get_class($arrayOfPricesInfoPricesInfoItem) : sprintf('%s(%s)', gettype($arrayOfPricesInfoPricesInfoItem), var_export($arrayOfPricesInfoPricesInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PricesInfo property can only contain items of type \StructType\PricesInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PricesInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PricesInfo[] $pricesInfo
     * @return \ArrayType\ArrayOfPricesInfo
     */
    public function setPricesInfo(array $pricesInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($pricesInfoArrayErrorMessage = self::validatePricesInfoForArrayConstraintsFromSetPricesInfo($pricesInfo))) {
            throw new \InvalidArgumentException($pricesInfoArrayErrorMessage, __LINE__);
        }
        if (is_null($pricesInfo) || (is_array($pricesInfo) && empty($pricesInfo))) {
            unset($this->PricesInfo);
        } else {
            $this->PricesInfo = $pricesInfo;
        }
        return $this;
    }
    /**
     * Add item to PricesInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\PricesInfo $item
     * @return \ArrayType\ArrayOfPricesInfo
     */
    public function addToPricesInfo(\StructType\PricesInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PricesInfo) {
            throw new \InvalidArgumentException(sprintf('The PricesInfo property can only contain items of type \StructType\PricesInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PricesInfo[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\PricesInfo|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\PricesInfo|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\PricesInfo|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\PricesInfo|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\PricesInfo|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string PricesInfo
     */
    public function getAttributeName()
    {
        return 'PricesInfo';
    }
}
