<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OfferCodage StructType
 * @subpackage Structs
 */
class OfferCodage extends AbstractStructBase
{
    /**
     * The TypeOS
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $TypeOS;
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Amount;
    /**
     * The EnumUniteFraisDossier
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $EnumUniteFraisDossier;
    /**
     * The X
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $X;
    /**
     * The Y
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Y;
    /**
     * The NuitSemaineEnum
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $NuitSemaineEnum;
    /**
     * Constructor method for OfferCodage
     * @uses OfferCodage::setTypeOS()
     * @uses OfferCodage::setAmount()
     * @uses OfferCodage::setEnumUniteFraisDossier()
     * @uses OfferCodage::setX()
     * @uses OfferCodage::setY()
     * @uses OfferCodage::setNuitSemaineEnum()
     * @param string $typeOS
     * @param float $amount
     * @param string $enumUniteFraisDossier
     * @param int $x
     * @param int $y
     * @param string $nuitSemaineEnum
     */
    public function __construct($typeOS = null, $amount = null, $enumUniteFraisDossier = null, $x = null, $y = null, $nuitSemaineEnum = null)
    {
        $this
            ->setTypeOS($typeOS)
            ->setAmount($amount)
            ->setEnumUniteFraisDossier($enumUniteFraisDossier)
            ->setX($x)
            ->setY($y)
            ->setNuitSemaineEnum($nuitSemaineEnum);
    }
    /**
     * Get TypeOS value
     * @return string
     */
    public function getTypeOS()
    {
        return $this->TypeOS;
    }
    /**
     * Set TypeOS value
     * @uses \EnumType\TypeOS::valueIsValid()
     * @uses \EnumType\TypeOS::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $typeOS
     * @return \StructType\OfferCodage
     */
    public function setTypeOS($typeOS = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TypeOS::valueIsValid($typeOS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TypeOS', is_array($typeOS) ? implode(', ', $typeOS) : var_export($typeOS, true), implode(', ', \EnumType\TypeOS::getValidValues())), __LINE__);
        }
        $this->TypeOS = $typeOS;
        return $this;
    }
    /**
     * Get Amount value
     * @return float
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\OfferCodage
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get EnumUniteFraisDossier value
     * @return string
     */
    public function getEnumUniteFraisDossier()
    {
        return $this->EnumUniteFraisDossier;
    }
    /**
     * Set EnumUniteFraisDossier value
     * @uses \EnumType\UniteFraisDossier::valueIsValid()
     * @uses \EnumType\UniteFraisDossier::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $enumUniteFraisDossier
     * @return \StructType\OfferCodage
     */
    public function setEnumUniteFraisDossier($enumUniteFraisDossier = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\UniteFraisDossier::valueIsValid($enumUniteFraisDossier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\UniteFraisDossier', is_array($enumUniteFraisDossier) ? implode(', ', $enumUniteFraisDossier) : var_export($enumUniteFraisDossier, true), implode(', ', \EnumType\UniteFraisDossier::getValidValues())), __LINE__);
        }
        $this->EnumUniteFraisDossier = $enumUniteFraisDossier;
        return $this;
    }
    /**
     * Get X value
     * @return int
     */
    public function getX()
    {
        return $this->X;
    }
    /**
     * Set X value
     * @param int $x
     * @return \StructType\OfferCodage
     */
    public function setX($x = null)
    {
        // validation for constraint: int
        if (!is_null($x) && !(is_int($x) || ctype_digit($x))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($x, true), gettype($x)), __LINE__);
        }
        $this->X = $x;
        return $this;
    }
    /**
     * Get Y value
     * @return int
     */
    public function getY()
    {
        return $this->Y;
    }
    /**
     * Set Y value
     * @param int $y
     * @return \StructType\OfferCodage
     */
    public function setY($y = null)
    {
        // validation for constraint: int
        if (!is_null($y) && !(is_int($y) || ctype_digit($y))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($y, true), gettype($y)), __LINE__);
        }
        $this->Y = $y;
        return $this;
    }
    /**
     * Get NuitSemaineEnum value
     * @return string
     */
    public function getNuitSemaineEnum()
    {
        return $this->NuitSemaineEnum;
    }
    /**
     * Set NuitSemaineEnum value
     * @uses \EnumType\NuitSemaineEnum::valueIsValid()
     * @uses \EnumType\NuitSemaineEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $nuitSemaineEnum
     * @return \StructType\OfferCodage
     */
    public function setNuitSemaineEnum($nuitSemaineEnum = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\NuitSemaineEnum::valueIsValid($nuitSemaineEnum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\NuitSemaineEnum', is_array($nuitSemaineEnum) ? implode(', ', $nuitSemaineEnum) : var_export($nuitSemaineEnum, true), implode(', ', \EnumType\NuitSemaineEnum::getValidValues())), __LINE__);
        }
        $this->NuitSemaineEnum = $nuitSemaineEnum;
        return $this;
    }
}
