<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetProductsPlanning StructType
 * @subpackage Structs
 */
class GetProductsPlanning extends AbstractStructBase
{
    /**
     * The EstablishmentID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $EstablishmentID;
    /**
     * The User
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\WSUser
     */
    public $User;
    /**
     * The ProductFilter
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ProductFilter
     */
    public $ProductFilter;
    /**
     * Constructor method for GetProductsPlanning
     * @uses GetProductsPlanning::setEstablishmentID()
     * @uses GetProductsPlanning::setUser()
     * @uses GetProductsPlanning::setProductFilter()
     * @param int $establishmentID
     * @param \StructType\WSUser $user
     * @param \StructType\ProductFilter $productFilter
     */
    public function __construct($establishmentID = null, \StructType\WSUser $user = null, \StructType\ProductFilter $productFilter = null)
    {
        $this
            ->setEstablishmentID($establishmentID)
            ->setUser($user)
            ->setProductFilter($productFilter);
    }
    /**
     * Get EstablishmentID value
     * @return int
     */
    public function getEstablishmentID()
    {
        return $this->EstablishmentID;
    }
    /**
     * Set EstablishmentID value
     * @param int $establishmentID
     * @return \StructType\GetProductsPlanning
     */
    public function setEstablishmentID($establishmentID = null)
    {
        // validation for constraint: int
        if (!is_null($establishmentID) && !(is_int($establishmentID) || ctype_digit($establishmentID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($establishmentID, true), gettype($establishmentID)), __LINE__);
        }
        $this->EstablishmentID = $establishmentID;
        return $this;
    }
    /**
     * Get User value
     * @return \StructType\WSUser|null
     */
    public function getUser()
    {
        return $this->User;
    }
    /**
     * Set User value
     * @param \StructType\WSUser $user
     * @return \StructType\GetProductsPlanning
     */
    public function setUser(\StructType\WSUser $user = null)
    {
        $this->User = $user;
        return $this;
    }
    /**
     * Get ProductFilter value
     * @return \StructType\ProductFilter|null
     */
    public function getProductFilter()
    {
        return $this->ProductFilter;
    }
    /**
     * Set ProductFilter value
     * @param \StructType\ProductFilter $productFilter
     * @return \StructType\GetProductsPlanning
     */
    public function setProductFilter(\StructType\ProductFilter $productFilter = null)
    {
        $this->ProductFilter = $productFilter;
        return $this;
    }
}
