<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductPlanning StructType
 * @subpackage Structs
 */
class ProductPlanning extends AbstractStructBase
{
    /**
     * The ProductID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ProductID;
    /**
     * The AvailabilityPeriods
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfAvailabilityPeriod
     */
    public $AvailabilityPeriods;
    /**
     * Constructor method for ProductPlanning
     * @uses ProductPlanning::setProductID()
     * @uses ProductPlanning::setAvailabilityPeriods()
     * @param int $productID
     * @param \ArrayType\ArrayOfAvailabilityPeriod $availabilityPeriods
     */
    public function __construct($productID = null, \ArrayType\ArrayOfAvailabilityPeriod $availabilityPeriods = null)
    {
        $this
            ->setProductID($productID)
            ->setAvailabilityPeriods($availabilityPeriods);
    }
    /**
     * Get ProductID value
     * @return int
     */
    public function getProductID()
    {
        return $this->ProductID;
    }
    /**
     * Set ProductID value
     * @param int $productID
     * @return \StructType\ProductPlanning
     */
    public function setProductID($productID = null)
    {
        // validation for constraint: int
        if (!is_null($productID) && !(is_int($productID) || ctype_digit($productID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($productID, true), gettype($productID)), __LINE__);
        }
        $this->ProductID = $productID;
        return $this;
    }
    /**
     * Get AvailabilityPeriods value
     * @return \ArrayType\ArrayOfAvailabilityPeriod|null
     */
    public function getAvailabilityPeriods()
    {
        return $this->AvailabilityPeriods;
    }
    /**
     * Set AvailabilityPeriods value
     * @param \ArrayType\ArrayOfAvailabilityPeriod $availabilityPeriods
     * @return \StructType\ProductPlanning
     */
    public function setAvailabilityPeriods(\ArrayType\ArrayOfAvailabilityPeriod $availabilityPeriods = null)
    {
        $this->AvailabilityPeriods = $availabilityPeriods;
        return $this;
    }
}
