<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfDay ArrayType
 * @subpackage Arrays
 */
class ArrayOfDay extends AbstractStructArrayBase
{
    /**
     * The day
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Day[]
     */
    public $day;
    /**
     * Constructor method for ArrayOfDay
     * @uses ArrayOfDay::setDay()
     * @param \StructType\Day[] $day
     */
    public function __construct(array $day = array())
    {
        $this
            ->setDay($day);
    }
    /**
     * Get day value
     * @return \StructType\Day[]|null
     */
    public function getDay()
    {
        return $this->day;
    }
    /**
     * This method is responsible for validating the values passed to the setDay method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDay method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDayForArrayConstraintsFromSetDay(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfDayDayItem) {
            // validation for constraint: itemType
            if (!$arrayOfDayDayItem instanceof \StructType\Day) {
                $invalidValues[] = is_object($arrayOfDayDayItem) ? get_class($arrayOfDayDayItem) : sprintf('%s(%s)', gettype($arrayOfDayDayItem), var_export($arrayOfDayDayItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The day property can only contain items of type \StructType\Day, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set day value
     * @throws \InvalidArgumentException
     * @param \StructType\Day[] $day
     * @return \ArrayType\ArrayOfDay
     */
    public function setDay(array $day = array())
    {
        // validation for constraint: array
        if ('' !== ($dayArrayErrorMessage = self::validateDayForArrayConstraintsFromSetDay($day))) {
            throw new \InvalidArgumentException($dayArrayErrorMessage, __LINE__);
        }
        $this->day = $day;
        return $this;
    }
    /**
     * Add item to day value
     * @throws \InvalidArgumentException
     * @param \StructType\Day $item
     * @return \ArrayType\ArrayOfDay
     */
    public function addToDay(\StructType\Day $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Day) {
            throw new \InvalidArgumentException(sprintf('The day property can only contain items of type \StructType\Day, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->day[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Day|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Day|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Day|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Day|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Day|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string day
     */
    public function getAttributeName()
    {
        return 'day';
    }
}
