<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductFilter StructType
 * @subpackage Structs
 */
class ProductFilter extends AbstractStructBase
{
    /**
     * The nbPersMin
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $nbPersMin;
    /**
     * The PriceMinimum
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $PriceMinimum;
    /**
     * The PriceMaximum
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $PriceMaximum;
    /**
     * The idList
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfInt
     */
    public $idList;
    /**
     * The productTypeList
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfProductType
     */
    public $productTypeList;
    /**
     * The idsSousTypes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfInt
     */
    public $idsSousTypes;
    /**
     * The marketingTypeList
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfInt
     */
    public $marketingTypeList;
    /**
     * The inventoryFilter
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfProductInventoryFilter
     */
    public $inventoryFilter;
    /**
     * The GridModels
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString_1
     */
    public $GridModels;
    /**
     * The PersonsDetails
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfDetailedPersonFilter
     */
    public $PersonsDetails;
    /**
     * Constructor method for ProductFilter
     * @uses ProductFilter::setNbPersMin()
     * @uses ProductFilter::setPriceMinimum()
     * @uses ProductFilter::setPriceMaximum()
     * @uses ProductFilter::setIdList()
     * @uses ProductFilter::setProductTypeList()
     * @uses ProductFilter::setIdsSousTypes()
     * @uses ProductFilter::setMarketingTypeList()
     * @uses ProductFilter::setInventoryFilter()
     * @uses ProductFilter::setGridModels()
     * @uses ProductFilter::setPersonsDetails()
     * @param int $nbPersMin
     * @param float $priceMinimum
     * @param float $priceMaximum
     * @param \ArrayType\ArrayOfInt $idList
     * @param \ArrayType\ArrayOfProductType $productTypeList
     * @param \ArrayType\ArrayOfInt $idsSousTypes
     * @param \ArrayType\ArrayOfInt $marketingTypeList
     * @param \ArrayType\ArrayOfProductInventoryFilter $inventoryFilter
     * @param \ArrayType\ArrayOfString_1 $gridModels
     * @param \ArrayType\ArrayOfDetailedPersonFilter $personsDetails
     */
    public function __construct($nbPersMin = null, $priceMinimum = null, $priceMaximum = null, \ArrayType\ArrayOfInt $idList = null, \ArrayType\ArrayOfProductType $productTypeList = null, \ArrayType\ArrayOfInt $idsSousTypes = null, \ArrayType\ArrayOfInt $marketingTypeList = null, \ArrayType\ArrayOfProductInventoryFilter $inventoryFilter = null, \ArrayType\ArrayOfString_1 $gridModels = null, \ArrayType\ArrayOfDetailedPersonFilter $personsDetails = null)
    {
        $this
            ->setNbPersMin($nbPersMin)
            ->setPriceMinimum($priceMinimum)
            ->setPriceMaximum($priceMaximum)
            ->setIdList($idList)
            ->setProductTypeList($productTypeList)
            ->setIdsSousTypes($idsSousTypes)
            ->setMarketingTypeList($marketingTypeList)
            ->setInventoryFilter($inventoryFilter)
            ->setGridModels($gridModels)
            ->setPersonsDetails($personsDetails);
    }
    /**
     * Get nbPersMin value
     * @return int
     */
    public function getNbPersMin()
    {
        return $this->nbPersMin;
    }
    /**
     * Set nbPersMin value
     * @param int $nbPersMin
     * @return \StructType\ProductFilter
     */
    public function setNbPersMin($nbPersMin = null)
    {
        // validation for constraint: int
        if (!is_null($nbPersMin) && !(is_int($nbPersMin) || ctype_digit($nbPersMin))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($nbPersMin, true), gettype($nbPersMin)), __LINE__);
        }
        $this->nbPersMin = $nbPersMin;
        return $this;
    }
    /**
     * Get PriceMinimum value
     * @return float
     */
    public function getPriceMinimum()
    {
        return $this->PriceMinimum;
    }
    /**
     * Set PriceMinimum value
     * @param float $priceMinimum
     * @return \StructType\ProductFilter
     */
    public function setPriceMinimum($priceMinimum = null)
    {
        // validation for constraint: float
        if (!is_null($priceMinimum) && !(is_float($priceMinimum) || is_numeric($priceMinimum))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($priceMinimum, true), gettype($priceMinimum)), __LINE__);
        }
        $this->PriceMinimum = $priceMinimum;
        return $this;
    }
    /**
     * Get PriceMaximum value
     * @return float
     */
    public function getPriceMaximum()
    {
        return $this->PriceMaximum;
    }
    /**
     * Set PriceMaximum value
     * @param float $priceMaximum
     * @return \StructType\ProductFilter
     */
    public function setPriceMaximum($priceMaximum = null)
    {
        // validation for constraint: float
        if (!is_null($priceMaximum) && !(is_float($priceMaximum) || is_numeric($priceMaximum))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($priceMaximum, true), gettype($priceMaximum)), __LINE__);
        }
        $this->PriceMaximum = $priceMaximum;
        return $this;
    }
    /**
     * Get idList value
     * @return \ArrayType\ArrayOfInt|null
     */
    public function getIdList()
    {
        return $this->idList;
    }
    /**
     * Set idList value
     * @param \ArrayType\ArrayOfInt $idList
     * @return \StructType\ProductFilter
     */
    public function setIdList(\ArrayType\ArrayOfInt $idList = null)
    {
        $this->idList = $idList;
        return $this;
    }
    /**
     * Get productTypeList value
     * @return \ArrayType\ArrayOfProductType|null
     */
    public function getProductTypeList()
    {
        return $this->productTypeList;
    }
    /**
     * Set productTypeList value
     * @param \ArrayType\ArrayOfProductType $productTypeList
     * @return \StructType\ProductFilter
     */
    public function setProductTypeList(\ArrayType\ArrayOfProductType $productTypeList = null)
    {
        $this->productTypeList = $productTypeList;
        return $this;
    }
    /**
     * Get idsSousTypes value
     * @return \ArrayType\ArrayOfInt|null
     */
    public function getIdsSousTypes()
    {
        return $this->idsSousTypes;
    }
    /**
     * Set idsSousTypes value
     * @param \ArrayType\ArrayOfInt $idsSousTypes
     * @return \StructType\ProductFilter
     */
    public function setIdsSousTypes(\ArrayType\ArrayOfInt $idsSousTypes = null)
    {
        $this->idsSousTypes = $idsSousTypes;
        return $this;
    }
    /**
     * Get marketingTypeList value
     * @return \ArrayType\ArrayOfInt|null
     */
    public function getMarketingTypeList()
    {
        return $this->marketingTypeList;
    }
    /**
     * Set marketingTypeList value
     * @param \ArrayType\ArrayOfInt $marketingTypeList
     * @return \StructType\ProductFilter
     */
    public function setMarketingTypeList(\ArrayType\ArrayOfInt $marketingTypeList = null)
    {
        $this->marketingTypeList = $marketingTypeList;
        return $this;
    }
    /**
     * Get inventoryFilter value
     * @return \ArrayType\ArrayOfProductInventoryFilter|null
     */
    public function getInventoryFilter()
    {
        return $this->inventoryFilter;
    }
    /**
     * Set inventoryFilter value
     * @param \ArrayType\ArrayOfProductInventoryFilter $inventoryFilter
     * @return \StructType\ProductFilter
     */
    public function setInventoryFilter(\ArrayType\ArrayOfProductInventoryFilter $inventoryFilter = null)
    {
        $this->inventoryFilter = $inventoryFilter;
        return $this;
    }
    /**
     * Get GridModels value
     * @return \ArrayType\ArrayOfString_1|null
     */
    public function getGridModels()
    {
        return $this->GridModels;
    }
    /**
     * Set GridModels value
     * @param \ArrayType\ArrayOfString_1 $gridModels
     * @return \StructType\ProductFilter
     */
    public function setGridModels(\ArrayType\ArrayOfString_1 $gridModels = null)
    {
        $this->GridModels = $gridModels;
        return $this;
    }
    /**
     * Get PersonsDetails value
     * @return \ArrayType\ArrayOfDetailedPersonFilter|null
     */
    public function getPersonsDetails()
    {
        return $this->PersonsDetails;
    }
    /**
     * Set PersonsDetails value
     * @param \ArrayType\ArrayOfDetailedPersonFilter $personsDetails
     * @return \StructType\ProductFilter
     */
    public function setPersonsDetails(\ArrayType\ArrayOfDetailedPersonFilter $personsDetails = null)
    {
        $this->PersonsDetails = $personsDetails;
        return $this;
    }
}
