<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPhotoCategory ArrayType
 * @subpackage Arrays
 */
class ArrayOfPhotoCategory extends AbstractStructArrayBase
{
    /**
     * The PhotoCategory
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $PhotoCategory;
    /**
     * Constructor method for ArrayOfPhotoCategory
     * @uses ArrayOfPhotoCategory::setPhotoCategory()
     * @param string[] $photoCategory
     */
    public function __construct(array $photoCategory = array())
    {
        $this
            ->setPhotoCategory($photoCategory);
    }
    /**
     * Get PhotoCategory value
     * @return string[]|null
     */
    public function getPhotoCategory()
    {
        return $this->PhotoCategory;
    }
    /**
     * This method is responsible for validating the values passed to the setPhotoCategory method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPhotoCategory method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePhotoCategoryForArrayConstraintsFromSetPhotoCategory(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfPhotoCategoryPhotoCategoryItem) {
            // validation for constraint: enumeration
            if (!\EnumType\PhotoCategory::valueIsValid($arrayOfPhotoCategoryPhotoCategoryItem)) {
                $invalidValues[] = is_object($arrayOfPhotoCategoryPhotoCategoryItem) ? get_class($arrayOfPhotoCategoryPhotoCategoryItem) : sprintf('%s(%s)', gettype($arrayOfPhotoCategoryPhotoCategoryItem), var_export($arrayOfPhotoCategoryPhotoCategoryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PhotoCategory', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\PhotoCategory::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PhotoCategory value
     * @uses \EnumType\PhotoCategory::valueIsValid()
     * @uses \EnumType\PhotoCategory::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $photoCategory
     * @return \ArrayType\ArrayOfPhotoCategory
     */
    public function setPhotoCategory(array $photoCategory = array())
    {
        // validation for constraint: array
        if ('' !== ($photoCategoryArrayErrorMessage = self::validatePhotoCategoryForArrayConstraintsFromSetPhotoCategory($photoCategory))) {
            throw new \InvalidArgumentException($photoCategoryArrayErrorMessage, __LINE__);
        }
        $this->PhotoCategory = $photoCategory;
        return $this;
    }
    /**
     * Add item to PhotoCategory value
     * @uses \EnumType\PhotoCategory::valueIsValid()
     * @uses \EnumType\PhotoCategory::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \ArrayType\ArrayOfPhotoCategory
     */
    public function addToPhotoCategory($item)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PhotoCategory::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PhotoCategory', is_array($item) ? implode(', ', $item) : var_export($item, true), implode(', ', \EnumType\PhotoCategory::getValidValues())), __LINE__);
        }
        $this->PhotoCategory[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return string|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return string|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return string|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return string|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return string|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Add element to array
     * @see AbstractStructArrayBase::add()
     * @throws \InvalidArgumentException
     * @uses \EnumType\PhotoCategory::valueIsValid()
     * @param string $item
     * @return \ArrayType\ArrayOfPhotoCategory
     */
    public function add($item)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PhotoCategory::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PhotoCategory', is_array($item) ? implode(', ', $item) : var_export($item, true), implode(', ', \EnumType\PhotoCategory::getValidValues())), __LINE__);
        }
        return parent::add($item);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string PhotoCategory
     */
    public function getAttributeName()
    {
        return 'PhotoCategory';
    }
}
