<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Person StructType
 * @subpackage Structs
 */
class Person extends AbstractStructBase
{
    /**
     * The Inclus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Inclus;
    /**
     * The Min
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Min;
    /**
     * The Max
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Max;
    /**
     * Constructor method for Person
     * @uses Person::setInclus()
     * @uses Person::setMin()
     * @uses Person::setMax()
     * @param int $inclus
     * @param int $min
     * @param int $max
     */
    public function __construct($inclus = null, $min = null, $max = null)
    {
        $this
            ->setInclus($inclus)
            ->setMin($min)
            ->setMax($max);
    }
    /**
     * Get Inclus value
     * @return int
     */
    public function getInclus()
    {
        return $this->Inclus;
    }
    /**
     * Set Inclus value
     * @param int $inclus
     * @return \StructType\Person
     */
    public function setInclus($inclus = null)
    {
        // validation for constraint: int
        if (!is_null($inclus) && !(is_int($inclus) || ctype_digit($inclus))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($inclus, true), gettype($inclus)), __LINE__);
        }
        $this->Inclus = $inclus;
        return $this;
    }
    /**
     * Get Min value
     * @return int
     */
    public function getMin()
    {
        return $this->Min;
    }
    /**
     * Set Min value
     * @param int $min
     * @return \StructType\Person
     */
    public function setMin($min = null)
    {
        // validation for constraint: int
        if (!is_null($min) && !(is_int($min) || ctype_digit($min))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($min, true), gettype($min)), __LINE__);
        }
        $this->Min = $min;
        return $this;
    }
    /**
     * Get Max value
     * @return int
     */
    public function getMax()
    {
        return $this->Max;
    }
    /**
     * Set Max value
     * @param int $max
     * @return \StructType\Person
     */
    public function setMax($max = null)
    {
        // validation for constraint: int
        if (!is_null($max) && !(is_int($max) || ctype_digit($max))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($max, true), gettype($max)), __LINE__);
        }
        $this->Max = $max;
        return $this;
    }
}
