<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfTunnelOption ArrayType
 * @subpackage Arrays
 */
class ArrayOfTunnelOption extends AbstractStructArrayBase
{
    /**
     * The TunnelOption
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\TunnelOption[]
     */
    public $TunnelOption;
    /**
     * Constructor method for ArrayOfTunnelOption
     * @uses ArrayOfTunnelOption::setTunnelOption()
     * @param \StructType\TunnelOption[] $tunnelOption
     */
    public function __construct(array $tunnelOption = array())
    {
        $this
            ->setTunnelOption($tunnelOption);
    }
    /**
     * Get TunnelOption value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\TunnelOption[]|null
     */
    public function getTunnelOption()
    {
        return isset($this->TunnelOption) ? $this->TunnelOption : null;
    }
    /**
     * This method is responsible for validating the values passed to the setTunnelOption method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTunnelOption method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTunnelOptionForArrayConstraintsFromSetTunnelOption(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfTunnelOptionTunnelOptionItem) {
            // validation for constraint: itemType
            if (!$arrayOfTunnelOptionTunnelOptionItem instanceof \StructType\TunnelOption) {
                $invalidValues[] = is_object($arrayOfTunnelOptionTunnelOptionItem) ? get_class($arrayOfTunnelOptionTunnelOptionItem) : sprintf('%s(%s)', gettype($arrayOfTunnelOptionTunnelOptionItem), var_export($arrayOfTunnelOptionTunnelOptionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TunnelOption property can only contain items of type \StructType\TunnelOption, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TunnelOption value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\TunnelOption[] $tunnelOption
     * @return \ArrayType\ArrayOfTunnelOption
     */
    public function setTunnelOption(array $tunnelOption = array())
    {
        // validation for constraint: array
        if ('' !== ($tunnelOptionArrayErrorMessage = self::validateTunnelOptionForArrayConstraintsFromSetTunnelOption($tunnelOption))) {
            throw new \InvalidArgumentException($tunnelOptionArrayErrorMessage, __LINE__);
        }
        if (is_null($tunnelOption) || (is_array($tunnelOption) && empty($tunnelOption))) {
            unset($this->TunnelOption);
        } else {
            $this->TunnelOption = $tunnelOption;
        }
        return $this;
    }
    /**
     * Add item to TunnelOption value
     * @throws \InvalidArgumentException
     * @param \StructType\TunnelOption $item
     * @return \ArrayType\ArrayOfTunnelOption
     */
    public function addToTunnelOption(\StructType\TunnelOption $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TunnelOption) {
            throw new \InvalidArgumentException(sprintf('The TunnelOption property can only contain items of type \StructType\TunnelOption, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TunnelOption[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\TunnelOption|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\TunnelOption|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\TunnelOption|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\TunnelOption|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\TunnelOption|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string TunnelOption
     */
    public function getAttributeName()
    {
        return 'TunnelOption';
    }
}
