<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentMeanSuspensionDate StructType
 * @subpackage Structs
 */
class PaymentMeanSuspensionDate extends AbstractStructBase
{
    /**
     * The StayBeginDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $StayBeginDate;
    /**
     * The StayEndDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $StayEndDate;
    /**
     * Constructor method for PaymentMeanSuspensionDate
     * @uses PaymentMeanSuspensionDate::setStayBeginDate()
     * @uses PaymentMeanSuspensionDate::setStayEndDate()
     * @param string $stayBeginDate
     * @param string $stayEndDate
     */
    public function __construct($stayBeginDate = null, $stayEndDate = null)
    {
        $this
            ->setStayBeginDate($stayBeginDate)
            ->setStayEndDate($stayEndDate);
    }
    /**
     * Get StayBeginDate value
     * @return string
     */
    public function getStayBeginDate()
    {
        return $this->StayBeginDate;
    }
    /**
     * Set StayBeginDate value
     * @param string $stayBeginDate
     * @return \StructType\PaymentMeanSuspensionDate
     */
    public function setStayBeginDate($stayBeginDate = null)
    {
        // validation for constraint: string
        if (!is_null($stayBeginDate) && !is_string($stayBeginDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stayBeginDate, true), gettype($stayBeginDate)), __LINE__);
        }
        $this->StayBeginDate = $stayBeginDate;
        return $this;
    }
    /**
     * Get StayEndDate value
     * @return string
     */
    public function getStayEndDate()
    {
        return $this->StayEndDate;
    }
    /**
     * Set StayEndDate value
     * @param string $stayEndDate
     * @return \StructType\PaymentMeanSuspensionDate
     */
    public function setStayEndDate($stayEndDate = null)
    {
        // validation for constraint: string
        if (!is_null($stayEndDate) && !is_string($stayEndDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stayEndDate, true), gettype($stayEndDate)), __LINE__);
        }
        $this->StayEndDate = $stayEndDate;
        return $this;
    }
}
