<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UfiFilter StructType
 * @subpackage Structs
 */
class UfiFilter extends AbstractStructBase
{
    /**
     * The idUFI
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $idUFI;
    /**
     * The radius
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $radius;
    /**
     * Constructor method for UfiFilter
     * @uses UfiFilter::setIdUFI()
     * @uses UfiFilter::setRadius()
     * @param int $idUFI
     * @param int $radius
     */
    public function __construct($idUFI = null, $radius = null)
    {
        $this
            ->setIdUFI($idUFI)
            ->setRadius($radius);
    }
    /**
     * Get idUFI value
     * @return int
     */
    public function getIdUFI()
    {
        return $this->idUFI;
    }
    /**
     * Set idUFI value
     * @param int $idUFI
     * @return \StructType\UfiFilter
     */
    public function setIdUFI($idUFI = null)
    {
        // validation for constraint: int
        if (!is_null($idUFI) && !(is_int($idUFI) || ctype_digit($idUFI))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idUFI, true), gettype($idUFI)), __LINE__);
        }
        $this->idUFI = $idUFI;
        return $this;
    }
    /**
     * Get radius value
     * @return int
     */
    public function getRadius()
    {
        return $this->radius;
    }
    /**
     * Set radius value
     * @param int $radius
     * @return \StructType\UfiFilter
     */
    public function setRadius($radius = null)
    {
        // validation for constraint: int
        if (!is_null($radius) && !(is_int($radius) || ctype_digit($radius))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($radius, true), gettype($radius)), __LINE__);
        }
        $this->radius = $radius;
        return $this;
    }
}
