<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Insurance StructType
 * @subpackage Structs
 */
class Insurance extends AbstractStructBase
{
    /**
     * The InsurancePrice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $InsurancePrice;
    /**
     * The InsuranceId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InsuranceId;
    /**
     * Constructor method for Insurance
     * @uses Insurance::setInsurancePrice()
     * @uses Insurance::setInsuranceId()
     * @param float $insurancePrice
     * @param string $insuranceId
     */
    public function __construct($insurancePrice = null, $insuranceId = null)
    {
        $this
            ->setInsurancePrice($insurancePrice)
            ->setInsuranceId($insuranceId);
    }
    /**
     * Get InsurancePrice value
     * @return float
     */
    public function getInsurancePrice()
    {
        return $this->InsurancePrice;
    }
    /**
     * Set InsurancePrice value
     * @param float $insurancePrice
     * @return \StructType\Insurance
     */
    public function setInsurancePrice($insurancePrice = null)
    {
        // validation for constraint: float
        if (!is_null($insurancePrice) && !(is_float($insurancePrice) || is_numeric($insurancePrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($insurancePrice, true), gettype($insurancePrice)), __LINE__);
        }
        $this->InsurancePrice = $insurancePrice;
        return $this;
    }
    /**
     * Get InsuranceId value
     * @return string|null
     */
    public function getInsuranceId()
    {
        return $this->InsuranceId;
    }
    /**
     * Set InsuranceId value
     * @param string $insuranceId
     * @return \StructType\Insurance
     */
    public function setInsuranceId($insuranceId = null)
    {
        // validation for constraint: string
        if (!is_null($insuranceId) && !is_string($insuranceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($insuranceId, true), gettype($insuranceId)), __LINE__);
        }
        $this->InsuranceId = $insuranceId;
        return $this;
    }
}
