<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfSpecificCustomerOption ArrayType
 * @subpackage Arrays
 */
class ArrayOfSpecificCustomerOption extends AbstractStructArrayBase
{
    /**
     * The SpecificCustomerOption
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\SpecificCustomerOption[]
     */
    public $SpecificCustomerOption;
    /**
     * Constructor method for ArrayOfSpecificCustomerOption
     * @uses ArrayOfSpecificCustomerOption::setSpecificCustomerOption()
     * @param \StructType\SpecificCustomerOption[] $specificCustomerOption
     */
    public function __construct(array $specificCustomerOption = array())
    {
        $this
            ->setSpecificCustomerOption($specificCustomerOption);
    }
    /**
     * Get SpecificCustomerOption value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\SpecificCustomerOption[]|null
     */
    public function getSpecificCustomerOption()
    {
        return isset($this->SpecificCustomerOption) ? $this->SpecificCustomerOption : null;
    }
    /**
     * This method is responsible for validating the values passed to the setSpecificCustomerOption method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSpecificCustomerOption method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSpecificCustomerOptionForArrayConstraintsFromSetSpecificCustomerOption(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfSpecificCustomerOptionSpecificCustomerOptionItem) {
            // validation for constraint: itemType
            if (!$arrayOfSpecificCustomerOptionSpecificCustomerOptionItem instanceof \StructType\SpecificCustomerOption) {
                $invalidValues[] = is_object($arrayOfSpecificCustomerOptionSpecificCustomerOptionItem) ? get_class($arrayOfSpecificCustomerOptionSpecificCustomerOptionItem) : sprintf('%s(%s)', gettype($arrayOfSpecificCustomerOptionSpecificCustomerOptionItem), var_export($arrayOfSpecificCustomerOptionSpecificCustomerOptionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SpecificCustomerOption property can only contain items of type \StructType\SpecificCustomerOption, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SpecificCustomerOption value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\SpecificCustomerOption[] $specificCustomerOption
     * @return \ArrayType\ArrayOfSpecificCustomerOption
     */
    public function setSpecificCustomerOption(array $specificCustomerOption = array())
    {
        // validation for constraint: array
        if ('' !== ($specificCustomerOptionArrayErrorMessage = self::validateSpecificCustomerOptionForArrayConstraintsFromSetSpecificCustomerOption($specificCustomerOption))) {
            throw new \InvalidArgumentException($specificCustomerOptionArrayErrorMessage, __LINE__);
        }
        if (is_null($specificCustomerOption) || (is_array($specificCustomerOption) && empty($specificCustomerOption))) {
            unset($this->SpecificCustomerOption);
        } else {
            $this->SpecificCustomerOption = $specificCustomerOption;
        }
        return $this;
    }
    /**
     * Add item to SpecificCustomerOption value
     * @throws \InvalidArgumentException
     * @param \StructType\SpecificCustomerOption $item
     * @return \ArrayType\ArrayOfSpecificCustomerOption
     */
    public function addToSpecificCustomerOption(\StructType\SpecificCustomerOption $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SpecificCustomerOption) {
            throw new \InvalidArgumentException(sprintf('The SpecificCustomerOption property can only contain items of type \StructType\SpecificCustomerOption, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SpecificCustomerOption[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\SpecificCustomerOption|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\SpecificCustomerOption|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\SpecificCustomerOption|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\SpecificCustomerOption|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\SpecificCustomerOption|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string SpecificCustomerOption
     */
    public function getAttributeName()
    {
        return 'SpecificCustomerOption';
    }
}
