<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfInsurance ArrayType
 * @subpackage Arrays
 */
class ArrayOfInsurance extends AbstractStructArrayBase
{
    /**
     * The Insurance
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Insurance[]
     */
    public $Insurance;
    /**
     * Constructor method for ArrayOfInsurance
     * @uses ArrayOfInsurance::setInsurance()
     * @param \StructType\Insurance[] $insurance
     */
    public function __construct(array $insurance = array())
    {
        $this
            ->setInsurance($insurance);
    }
    /**
     * Get Insurance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Insurance[]|null
     */
    public function getInsurance()
    {
        return isset($this->Insurance) ? $this->Insurance : null;
    }
    /**
     * This method is responsible for validating the values passed to the setInsurance method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInsurance method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInsuranceForArrayConstraintsFromSetInsurance(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfInsuranceInsuranceItem) {
            // validation for constraint: itemType
            if (!$arrayOfInsuranceInsuranceItem instanceof \StructType\Insurance) {
                $invalidValues[] = is_object($arrayOfInsuranceInsuranceItem) ? get_class($arrayOfInsuranceInsuranceItem) : sprintf('%s(%s)', gettype($arrayOfInsuranceInsuranceItem), var_export($arrayOfInsuranceInsuranceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Insurance property can only contain items of type \StructType\Insurance, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Insurance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Insurance[] $insurance
     * @return \ArrayType\ArrayOfInsurance
     */
    public function setInsurance(array $insurance = array())
    {
        // validation for constraint: array
        if ('' !== ($insuranceArrayErrorMessage = self::validateInsuranceForArrayConstraintsFromSetInsurance($insurance))) {
            throw new \InvalidArgumentException($insuranceArrayErrorMessage, __LINE__);
        }
        if (is_null($insurance) || (is_array($insurance) && empty($insurance))) {
            unset($this->Insurance);
        } else {
            $this->Insurance = $insurance;
        }
        return $this;
    }
    /**
     * Add item to Insurance value
     * @throws \InvalidArgumentException
     * @param \StructType\Insurance $item
     * @return \ArrayType\ArrayOfInsurance
     */
    public function addToInsurance(\StructType\Insurance $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Insurance) {
            throw new \InvalidArgumentException(sprintf('The Insurance property can only contain items of type \StructType\Insurance, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Insurance[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Insurance|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Insurance|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Insurance|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Insurance|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Insurance|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Insurance
     */
    public function getAttributeName()
    {
        return 'Insurance';
    }
}
