<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Product StructType
 * @subpackage Structs
 */
class Product extends AbstractStructBase
{
    /**
     * The id
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $id;
    /**
     * The nbPersMax
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $nbPersMax;
    /**
     * The elc
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $elc;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The urlPicture
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString_1
     */
    public $urlPicture;
    /**
     * The descriptionText
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $descriptionText;
    /**
     * The nbPersText
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $nbPersText;
    /**
     * Constructor method for Product
     * @uses Product::setId()
     * @uses Product::setNbPersMax()
     * @uses Product::setElc()
     * @uses Product::setName()
     * @uses Product::setUrlPicture()
     * @uses Product::setDescriptionText()
     * @uses Product::setNbPersText()
     * @param int $id
     * @param int $nbPersMax
     * @param string $elc
     * @param string $name
     * @param \ArrayType\ArrayOfString_1 $urlPicture
     * @param string $descriptionText
     * @param string $nbPersText
     */
    public function __construct($id = null, $nbPersMax = null, $elc = null, $name = null, \ArrayType\ArrayOfString_1 $urlPicture = null, $descriptionText = null, $nbPersText = null)
    {
        $this
            ->setId($id)
            ->setNbPersMax($nbPersMax)
            ->setElc($elc)
            ->setName($name)
            ->setUrlPicture($urlPicture)
            ->setDescriptionText($descriptionText)
            ->setNbPersText($nbPersText);
    }
    /**
     * Get id value
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param int $id
     * @return \StructType\Product
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get nbPersMax value
     * @return int
     */
    public function getNbPersMax()
    {
        return $this->nbPersMax;
    }
    /**
     * Set nbPersMax value
     * @param int $nbPersMax
     * @return \StructType\Product
     */
    public function setNbPersMax($nbPersMax = null)
    {
        // validation for constraint: int
        if (!is_null($nbPersMax) && !(is_int($nbPersMax) || ctype_digit($nbPersMax))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($nbPersMax, true), gettype($nbPersMax)), __LINE__);
        }
        $this->nbPersMax = $nbPersMax;
        return $this;
    }
    /**
     * Get elc value
     * @return string
     */
    public function getElc()
    {
        return $this->elc;
    }
    /**
     * Set elc value
     * @uses \EnumType\TypeHebergement::valueIsValid()
     * @uses \EnumType\TypeHebergement::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $elc
     * @return \StructType\Product
     */
    public function setElc($elc = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TypeHebergement::valueIsValid($elc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TypeHebergement', is_array($elc) ? implode(', ', $elc) : var_export($elc, true), implode(', ', \EnumType\TypeHebergement::getValidValues())), __LINE__);
        }
        $this->elc = $elc;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\Product
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get urlPicture value
     * @return \ArrayType\ArrayOfString_1|null
     */
    public function getUrlPicture()
    {
        return $this->urlPicture;
    }
    /**
     * Set urlPicture value
     * @param \ArrayType\ArrayOfString_1 $urlPicture
     * @return \StructType\Product
     */
    public function setUrlPicture(\ArrayType\ArrayOfString_1 $urlPicture = null)
    {
        $this->urlPicture = $urlPicture;
        return $this;
    }
    /**
     * Get descriptionText value
     * @return string|null
     */
    public function getDescriptionText()
    {
        return $this->descriptionText;
    }
    /**
     * Set descriptionText value
     * @param string $descriptionText
     * @return \StructType\Product
     */
    public function setDescriptionText($descriptionText = null)
    {
        // validation for constraint: string
        if (!is_null($descriptionText) && !is_string($descriptionText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descriptionText, true), gettype($descriptionText)), __LINE__);
        }
        $this->descriptionText = $descriptionText;
        return $this;
    }
    /**
     * Get nbPersText value
     * @return string|null
     */
    public function getNbPersText()
    {
        return $this->nbPersText;
    }
    /**
     * Set nbPersText value
     * @param string $nbPersText
     * @return \StructType\Product
     */
    public function setNbPersText($nbPersText = null)
    {
        // validation for constraint: string
        if (!is_null($nbPersText) && !is_string($nbPersText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nbPersText, true), gettype($nbPersText)), __LINE__);
        }
        $this->nbPersText = $nbPersText;
        return $this;
    }
}
