<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TunnelCartInformation StructType
 * @subpackage Structs
 */
class TunnelCartInformation extends AbstractStructBase
{
    /**
     * The BirthDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $BirthDate;
    /**
     * The Adress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Adress;
    /**
     * The PostCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PostCode;
    /**
     * The Town
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Town;
    /**
     * The Country
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Country;
    /**
     * The Tel
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Tel;
    /**
     * The Mobile
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Mobile;
    /**
     * The InfoPitch
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\InformationPitch
     */
    public $InfoPitch;
    /**
     * The DiscountCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DiscountCode;
    /**
     * The InsuranceIds
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfInt_1
     */
    public $InsuranceIds;
    /**
     * The UrlParamsPremium
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UrlParamsPremium;
    /**
     * The InsuranceChaine
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfSimpleInsurance
     */
    public $InsuranceChaine;
    /**
     * The CartExternalBookingUrl
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CartExternalBookingUrl;
    /**
     * The CartExternalProductInfoUrl
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CartExternalProductInfoUrl;
    /**
     * The Email
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Email;
    /**
     * The FirstName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FirstName;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The TunnelAccompanyingPersonList
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfTunnelAccompanyingPerson
     */
    public $TunnelAccompanyingPersonList;
    /**
     * The Comment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Comment;
    /**
     * The IsoBookingLanguage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IsoBookingLanguage;
    /**
     * Constructor method for TunnelCartInformation
     * @uses TunnelCartInformation::setBirthDate()
     * @uses TunnelCartInformation::setAdress()
     * @uses TunnelCartInformation::setPostCode()
     * @uses TunnelCartInformation::setTown()
     * @uses TunnelCartInformation::setCountry()
     * @uses TunnelCartInformation::setTel()
     * @uses TunnelCartInformation::setMobile()
     * @uses TunnelCartInformation::setInfoPitch()
     * @uses TunnelCartInformation::setDiscountCode()
     * @uses TunnelCartInformation::setInsuranceIds()
     * @uses TunnelCartInformation::setUrlParamsPremium()
     * @uses TunnelCartInformation::setInsuranceChaine()
     * @uses TunnelCartInformation::setCartExternalBookingUrl()
     * @uses TunnelCartInformation::setCartExternalProductInfoUrl()
     * @uses TunnelCartInformation::setEmail()
     * @uses TunnelCartInformation::setFirstName()
     * @uses TunnelCartInformation::setName()
     * @uses TunnelCartInformation::setTunnelAccompanyingPersonList()
     * @uses TunnelCartInformation::setComment()
     * @uses TunnelCartInformation::setIsoBookingLanguage()
     * @param string $birthDate
     * @param string $adress
     * @param string $postCode
     * @param string $town
     * @param string $country
     * @param string $tel
     * @param string $mobile
     * @param \StructType\InformationPitch $infoPitch
     * @param string $discountCode
     * @param \ArrayType\ArrayOfInt_1 $insuranceIds
     * @param string $urlParamsPremium
     * @param \ArrayType\ArrayOfSimpleInsurance $insuranceChaine
     * @param string $cartExternalBookingUrl
     * @param string $cartExternalProductInfoUrl
     * @param string $email
     * @param string $firstName
     * @param string $name
     * @param \ArrayType\ArrayOfTunnelAccompanyingPerson $tunnelAccompanyingPersonList
     * @param string $comment
     * @param string $isoBookingLanguage
     */
    public function __construct($birthDate = null, $adress = null, $postCode = null, $town = null, $country = null, $tel = null, $mobile = null, \StructType\InformationPitch $infoPitch = null, $discountCode = null, \ArrayType\ArrayOfInt_1 $insuranceIds = null, $urlParamsPremium = null, \ArrayType\ArrayOfSimpleInsurance $insuranceChaine = null, $cartExternalBookingUrl = null, $cartExternalProductInfoUrl = null, $email = null, $firstName = null, $name = null, \ArrayType\ArrayOfTunnelAccompanyingPerson $tunnelAccompanyingPersonList = null, $comment = null, $isoBookingLanguage = null)
    {
        $this
            ->setBirthDate($birthDate)
            ->setAdress($adress)
            ->setPostCode($postCode)
            ->setTown($town)
            ->setCountry($country)
            ->setTel($tel)
            ->setMobile($mobile)
            ->setInfoPitch($infoPitch)
            ->setDiscountCode($discountCode)
            ->setInsuranceIds($insuranceIds)
            ->setUrlParamsPremium($urlParamsPremium)
            ->setInsuranceChaine($insuranceChaine)
            ->setCartExternalBookingUrl($cartExternalBookingUrl)
            ->setCartExternalProductInfoUrl($cartExternalProductInfoUrl)
            ->setEmail($email)
            ->setFirstName($firstName)
            ->setName($name)
            ->setTunnelAccompanyingPersonList($tunnelAccompanyingPersonList)
            ->setComment($comment)
            ->setIsoBookingLanguage($isoBookingLanguage);
    }
    /**
     * Get BirthDate value
     * @return string
     */
    public function getBirthDate()
    {
        return $this->BirthDate;
    }
    /**
     * Set BirthDate value
     * @param string $birthDate
     * @return \StructType\TunnelCartInformation
     */
    public function setBirthDate($birthDate = null)
    {
        // validation for constraint: string
        if (!is_null($birthDate) && !is_string($birthDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($birthDate, true), gettype($birthDate)), __LINE__);
        }
        $this->BirthDate = $birthDate;
        return $this;
    }
    /**
     * Get Adress value
     * @return string|null
     */
    public function getAdress()
    {
        return $this->Adress;
    }
    /**
     * Set Adress value
     * @param string $adress
     * @return \StructType\TunnelCartInformation
     */
    public function setAdress($adress = null)
    {
        // validation for constraint: string
        if (!is_null($adress) && !is_string($adress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adress, true), gettype($adress)), __LINE__);
        }
        $this->Adress = $adress;
        return $this;
    }
    /**
     * Get PostCode value
     * @return string|null
     */
    public function getPostCode()
    {
        return $this->PostCode;
    }
    /**
     * Set PostCode value
     * @param string $postCode
     * @return \StructType\TunnelCartInformation
     */
    public function setPostCode($postCode = null)
    {
        // validation for constraint: string
        if (!is_null($postCode) && !is_string($postCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postCode, true), gettype($postCode)), __LINE__);
        }
        $this->PostCode = $postCode;
        return $this;
    }
    /**
     * Get Town value
     * @return string|null
     */
    public function getTown()
    {
        return $this->Town;
    }
    /**
     * Set Town value
     * @param string $town
     * @return \StructType\TunnelCartInformation
     */
    public function setTown($town = null)
    {
        // validation for constraint: string
        if (!is_null($town) && !is_string($town)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($town, true), gettype($town)), __LINE__);
        }
        $this->Town = $town;
        return $this;
    }
    /**
     * Get Country value
     * @return string|null
     */
    public function getCountry()
    {
        return $this->Country;
    }
    /**
     * Set Country value
     * @param string $country
     * @return \StructType\TunnelCartInformation
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($country, true), gettype($country)), __LINE__);
        }
        $this->Country = $country;
        return $this;
    }
    /**
     * Get Tel value
     * @return string|null
     */
    public function getTel()
    {
        return $this->Tel;
    }
    /**
     * Set Tel value
     * @param string $tel
     * @return \StructType\TunnelCartInformation
     */
    public function setTel($tel = null)
    {
        // validation for constraint: string
        if (!is_null($tel) && !is_string($tel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tel, true), gettype($tel)), __LINE__);
        }
        $this->Tel = $tel;
        return $this;
    }
    /**
     * Get Mobile value
     * @return string|null
     */
    public function getMobile()
    {
        return $this->Mobile;
    }
    /**
     * Set Mobile value
     * @param string $mobile
     * @return \StructType\TunnelCartInformation
     */
    public function setMobile($mobile = null)
    {
        // validation for constraint: string
        if (!is_null($mobile) && !is_string($mobile)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mobile, true), gettype($mobile)), __LINE__);
        }
        $this->Mobile = $mobile;
        return $this;
    }
    /**
     * Get InfoPitch value
     * @return \StructType\InformationPitch|null
     */
    public function getInfoPitch()
    {
        return $this->InfoPitch;
    }
    /**
     * Set InfoPitch value
     * @param \StructType\InformationPitch $infoPitch
     * @return \StructType\TunnelCartInformation
     */
    public function setInfoPitch(\StructType\InformationPitch $infoPitch = null)
    {
        $this->InfoPitch = $infoPitch;
        return $this;
    }
    /**
     * Get DiscountCode value
     * @return string|null
     */
    public function getDiscountCode()
    {
        return $this->DiscountCode;
    }
    /**
     * Set DiscountCode value
     * @param string $discountCode
     * @return \StructType\TunnelCartInformation
     */
    public function setDiscountCode($discountCode = null)
    {
        // validation for constraint: string
        if (!is_null($discountCode) && !is_string($discountCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($discountCode, true), gettype($discountCode)), __LINE__);
        }
        $this->DiscountCode = $discountCode;
        return $this;
    }
    /**
     * Get InsuranceIds value
     * @return \ArrayType\ArrayOfInt_1|null
     */
    public function getInsuranceIds()
    {
        return $this->InsuranceIds;
    }
    /**
     * Set InsuranceIds value
     * @param \ArrayType\ArrayOfInt_1 $insuranceIds
     * @return \StructType\TunnelCartInformation
     */
    public function setInsuranceIds(\ArrayType\ArrayOfInt_1 $insuranceIds = null)
    {
        $this->InsuranceIds = $insuranceIds;
        return $this;
    }
    /**
     * Get UrlParamsPremium value
     * @return string|null
     */
    public function getUrlParamsPremium()
    {
        return $this->UrlParamsPremium;
    }
    /**
     * Set UrlParamsPremium value
     * @param string $urlParamsPremium
     * @return \StructType\TunnelCartInformation
     */
    public function setUrlParamsPremium($urlParamsPremium = null)
    {
        // validation for constraint: string
        if (!is_null($urlParamsPremium) && !is_string($urlParamsPremium)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($urlParamsPremium, true), gettype($urlParamsPremium)), __LINE__);
        }
        $this->UrlParamsPremium = $urlParamsPremium;
        return $this;
    }
    /**
     * Get InsuranceChaine value
     * @return \ArrayType\ArrayOfSimpleInsurance|null
     */
    public function getInsuranceChaine()
    {
        return $this->InsuranceChaine;
    }
    /**
     * Set InsuranceChaine value
     * @param \ArrayType\ArrayOfSimpleInsurance $insuranceChaine
     * @return \StructType\TunnelCartInformation
     */
    public function setInsuranceChaine(\ArrayType\ArrayOfSimpleInsurance $insuranceChaine = null)
    {
        $this->InsuranceChaine = $insuranceChaine;
        return $this;
    }
    /**
     * Get CartExternalBookingUrl value
     * @return string|null
     */
    public function getCartExternalBookingUrl()
    {
        return $this->CartExternalBookingUrl;
    }
    /**
     * Set CartExternalBookingUrl value
     * @param string $cartExternalBookingUrl
     * @return \StructType\TunnelCartInformation
     */
    public function setCartExternalBookingUrl($cartExternalBookingUrl = null)
    {
        // validation for constraint: string
        if (!is_null($cartExternalBookingUrl) && !is_string($cartExternalBookingUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cartExternalBookingUrl, true), gettype($cartExternalBookingUrl)), __LINE__);
        }
        $this->CartExternalBookingUrl = $cartExternalBookingUrl;
        return $this;
    }
    /**
     * Get CartExternalProductInfoUrl value
     * @return string|null
     */
    public function getCartExternalProductInfoUrl()
    {
        return $this->CartExternalProductInfoUrl;
    }
    /**
     * Set CartExternalProductInfoUrl value
     * @param string $cartExternalProductInfoUrl
     * @return \StructType\TunnelCartInformation
     */
    public function setCartExternalProductInfoUrl($cartExternalProductInfoUrl = null)
    {
        // validation for constraint: string
        if (!is_null($cartExternalProductInfoUrl) && !is_string($cartExternalProductInfoUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cartExternalProductInfoUrl, true), gettype($cartExternalProductInfoUrl)), __LINE__);
        }
        $this->CartExternalProductInfoUrl = $cartExternalProductInfoUrl;
        return $this;
    }
    /**
     * Get Email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @param string $email
     * @return \StructType\TunnelCartInformation
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        $this->Email = $email;
        return $this;
    }
    /**
     * Get FirstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->FirstName;
    }
    /**
     * Set FirstName value
     * @param string $firstName
     * @return \StructType\TunnelCartInformation
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstName, true), gettype($firstName)), __LINE__);
        }
        $this->FirstName = $firstName;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\TunnelCartInformation
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get TunnelAccompanyingPersonList value
     * @return \ArrayType\ArrayOfTunnelAccompanyingPerson|null
     */
    public function getTunnelAccompanyingPersonList()
    {
        return $this->TunnelAccompanyingPersonList;
    }
    /**
     * Set TunnelAccompanyingPersonList value
     * @param \ArrayType\ArrayOfTunnelAccompanyingPerson $tunnelAccompanyingPersonList
     * @return \StructType\TunnelCartInformation
     */
    public function setTunnelAccompanyingPersonList(\ArrayType\ArrayOfTunnelAccompanyingPerson $tunnelAccompanyingPersonList = null)
    {
        $this->TunnelAccompanyingPersonList = $tunnelAccompanyingPersonList;
        return $this;
    }
    /**
     * Get Comment value
     * @return string|null
     */
    public function getComment()
    {
        return $this->Comment;
    }
    /**
     * Set Comment value
     * @param string $comment
     * @return \StructType\TunnelCartInformation
     */
    public function setComment($comment = null)
    {
        // validation for constraint: string
        if (!is_null($comment) && !is_string($comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comment, true), gettype($comment)), __LINE__);
        }
        $this->Comment = $comment;
        return $this;
    }
    /**
     * Get IsoBookingLanguage value
     * @return string|null
     */
    public function getIsoBookingLanguage()
    {
        return $this->IsoBookingLanguage;
    }
    /**
     * Set IsoBookingLanguage value
     * @param string $isoBookingLanguage
     * @return \StructType\TunnelCartInformation
     */
    public function setIsoBookingLanguage($isoBookingLanguage = null)
    {
        // validation for constraint: string
        if (!is_null($isoBookingLanguage) && !is_string($isoBookingLanguage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($isoBookingLanguage, true), gettype($isoBookingLanguage)), __LINE__);
        }
        $this->IsoBookingLanguage = $isoBookingLanguage;
        return $this;
    }
}
