<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Territorial StructType
 * @subpackage Structs
 */
class Territorial extends AbstractStructBase
{
    /**
     * The countryCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $countryCode;
    /**
     * The administrativeZone1Code
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $administrativeZone1Code;
    /**
     * The administrativeZone2Code
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $administrativeZone2Code;
    /**
     * Constructor method for Territorial
     * @uses Territorial::setCountryCode()
     * @uses Territorial::setAdministrativeZone1Code()
     * @uses Territorial::setAdministrativeZone2Code()
     * @param string $countryCode
     * @param string $administrativeZone1Code
     * @param string $administrativeZone2Code
     */
    public function __construct($countryCode = null, $administrativeZone1Code = null, $administrativeZone2Code = null)
    {
        $this
            ->setCountryCode($countryCode)
            ->setAdministrativeZone1Code($administrativeZone1Code)
            ->setAdministrativeZone2Code($administrativeZone2Code);
    }
    /**
     * Get countryCode value
     * @return string|null
     */
    public function getCountryCode()
    {
        return $this->countryCode;
    }
    /**
     * Set countryCode value
     * @param string $countryCode
     * @return \StructType\Territorial
     */
    public function setCountryCode($countryCode = null)
    {
        // validation for constraint: string
        if (!is_null($countryCode) && !is_string($countryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryCode, true), gettype($countryCode)), __LINE__);
        }
        $this->countryCode = $countryCode;
        return $this;
    }
    /**
     * Get administrativeZone1Code value
     * @return string|null
     */
    public function getAdministrativeZone1Code()
    {
        return $this->administrativeZone1Code;
    }
    /**
     * Set administrativeZone1Code value
     * @param string $administrativeZone1Code
     * @return \StructType\Territorial
     */
    public function setAdministrativeZone1Code($administrativeZone1Code = null)
    {
        // validation for constraint: string
        if (!is_null($administrativeZone1Code) && !is_string($administrativeZone1Code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($administrativeZone1Code, true), gettype($administrativeZone1Code)), __LINE__);
        }
        $this->administrativeZone1Code = $administrativeZone1Code;
        return $this;
    }
    /**
     * Get administrativeZone2Code value
     * @return string|null
     */
    public function getAdministrativeZone2Code()
    {
        return $this->administrativeZone2Code;
    }
    /**
     * Set administrativeZone2Code value
     * @param string $administrativeZone2Code
     * @return \StructType\Territorial
     */
    public function setAdministrativeZone2Code($administrativeZone2Code = null)
    {
        // validation for constraint: string
        if (!is_null($administrativeZone2Code) && !is_string($administrativeZone2Code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($administrativeZone2Code, true), gettype($administrativeZone2Code)), __LINE__);
        }
        $this->administrativeZone2Code = $administrativeZone2Code;
        return $this;
    }
}
