<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SocialNetwork StructType
 * @subpackage Structs
 */
class SocialNetwork extends AbstractStructBase
{
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - use: required
     * @var int
     */
    public $Id;
    /**
     * The EnumName
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $EnumName;
    /**
     * The KeyTrad
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $KeyTrad;
    /**
     * The Url
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Url;
    /**
     * Constructor method for SocialNetwork
     * @uses SocialNetwork::setId()
     * @uses SocialNetwork::setEnumName()
     * @uses SocialNetwork::setKeyTrad()
     * @uses SocialNetwork::setUrl()
     * @param int $id
     * @param string $enumName
     * @param string $keyTrad
     * @param string $url
     */
    public function __construct($id = null, $enumName = null, $keyTrad = null, $url = null)
    {
        $this
            ->setId($id)
            ->setEnumName($enumName)
            ->setKeyTrad($keyTrad)
            ->setUrl($url);
    }
    /**
     * Get Id value
     * @return int
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \StructType\SocialNetwork
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get EnumName value
     * @return string
     */
    public function getEnumName()
    {
        return $this->EnumName;
    }
    /**
     * Set EnumName value
     * @uses \EnumType\SocialNetworksName::valueIsValid()
     * @uses \EnumType\SocialNetworksName::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $enumName
     * @return \StructType\SocialNetwork
     */
    public function setEnumName($enumName = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SocialNetworksName::valueIsValid($enumName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\SocialNetworksName', is_array($enumName) ? implode(', ', $enumName) : var_export($enumName, true), implode(', ', \EnumType\SocialNetworksName::getValidValues())), __LINE__);
        }
        $this->EnumName = $enumName;
        return $this;
    }
    /**
     * Get KeyTrad value
     * @return string|null
     */
    public function getKeyTrad()
    {
        return $this->KeyTrad;
    }
    /**
     * Set KeyTrad value
     * @param string $keyTrad
     * @return \StructType\SocialNetwork
     */
    public function setKeyTrad($keyTrad = null)
    {
        // validation for constraint: string
        if (!is_null($keyTrad) && !is_string($keyTrad)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($keyTrad, true), gettype($keyTrad)), __LINE__);
        }
        $this->KeyTrad = $keyTrad;
        return $this;
    }
    /**
     * Get Url value
     * @return string|null
     */
    public function getUrl()
    {
        return $this->Url;
    }
    /**
     * Set Url value
     * @param string $url
     * @return \StructType\SocialNetwork
     */
    public function setUrl($url = null)
    {
        // validation for constraint: string
        if (!is_null($url) && !is_string($url)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($url, true), gettype($url)), __LINE__);
        }
        $this->Url = $url;
        return $this;
    }
}
